/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class SimpleObjectWrapper
implements ObjectWrapper {
    static final SimpleObjectWrapper instance = new SimpleObjectWrapper();
    private int defaultDateType = 0;

    protected SimpleObjectWrapper() {
    }

    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TemplateModel) {
            return (TemplateModel)obj;
        }
        if (obj instanceof String) {
            return new SimpleScalar((String)obj);
        }
        if (obj instanceof Number) {
            return new SimpleNumber((Number)obj);
        }
        if (obj instanceof Date) {
            if (obj instanceof java.sql.Date) {
                return new SimpleDate((java.sql.Date)obj);
            }
            if (obj instanceof Time) {
                return new SimpleDate((Time)obj);
            }
            if (obj instanceof Timestamp) {
                return new SimpleDate((Timestamp)obj);
            }
            return new SimpleDate((Date)obj, this.defaultDateType);
        }
        if (obj.getClass().isArray()) {
            obj = this.convertArray(obj);
        }
        if (obj instanceof Collection) {
            return new SimpleSequence((Collection)obj, this);
        }
        if (obj instanceof Map) {
            return new SimpleHash((Map)obj, this);
        }
        if (obj instanceof Boolean) {
            return obj.equals(Boolean.TRUE) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (obj instanceof Iterator) {
            return new SimpleCollection((Iterator)obj, (ObjectWrapper)this);
        }
        return this.handleUnknownType(obj);
    }

    public synchronized void setDefaultDateType(int defaultDateType) {
        this.defaultDateType = defaultDateType;
    }

    int getDefaultDateType() {
        return this.defaultDateType;
    }

    protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
        throw new TemplateModelException("Don't know how to present an object of this type to a template: " + obj.getClass().getName());
    }

    protected Object convertArray(Object arr) {
        int size = Array.getLength(arr);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(arr, i));
        }
        return list;
    }
}

