/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.BodyInstruction;
import freemarker.template.BreakInstruction;
import freemarker.template.Configurable;
import freemarker.template.Configuration;
import freemarker.template.Expression;
import freemarker.template.Identifier;
import freemarker.template.Include;
import freemarker.template.IteratorBlock;
import freemarker.template.LocalContext;
import freemarker.template.Macro;
import freemarker.template.SimpleHash;
import freemarker.template.StopException;
import freemarker.template.Template;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TransformControl;
import freemarker.template.UnifiedCall;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class Environment
extends Configurable {
    private static final ThreadLocal threadEnv = new ThreadLocal();
    private static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static final Map localizedNumberFormats = new HashMap();
    private static final Map localizedDateFormats = new HashMap();
    private final TemplateHashModel rootDataModel;
    private final ArrayList elementStack = new ArrayList();
    private NumberFormat numberFormat;
    private Map numberFormats;
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private Map[] dateFormats;
    private Collator collator;
    private Writer out;
    private Macro.Context currentMacroContext;
    private ArrayList localContextStack;
    private ArrayList namespaceStack = new ArrayList();
    private Namespace mainNamespace;
    private Namespace currentNamespace;
    private Namespace globalNamespace;
    private HashMap loadedLibs;
    private Throwable lastThrowable = null;
    private HashMap macroToNamespaceLookup = new HashMap();
    private static final Writer NULL_WRITER = new Writer(){

        public void write(char[] cbuf, int off, int len) {
        }

        public void flush() {
        }

        public void close() {
        }
    };
    private static final Writer EMPTY_BODY_WRITER = new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (len > 0) {
                throw new IOException("This transform does no allow nested content.");
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    };

    public static Environment getCurrentEnvironment() {
        return (Environment)threadEnv.get();
    }

    Environment(Template template, TemplateHashModel rootDataModel, Writer out) {
        super(template);
        this.globalNamespace = new Namespace();
        this.currentNamespace = this.mainNamespace = new Namespace();
        this.namespaceStack.add(this.currentNamespace);
        this.out = out;
        this.rootDataModel = rootDataModel;
        this.importMacros(template);
    }

    public Template getTemplate() {
        return (Template)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws TemplateException, IOException {
        Object savedEnv = threadEnv.get();
        threadEnv.set(this);
        try {
            this.visit(this.getTemplate().rootElement);
        }
        finally {
            threadEnv.set(savedEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement element) throws TemplateException, IOException {
        this.pushElement(element);
        try {
            element.accept(this);
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement element, TemplateTransformModel transform, Map args) throws TemplateException, IOException {
        block17: {
            try {
                Writer tw = transform.getWriter(this.out, args);
                if (tw == null) {
                    tw = EMPTY_BODY_WRITER;
                }
                TransformControl tc = tw instanceof TransformControl ? (TransformControl)((Object)tw) : null;
                Writer prevOut = this.out;
                this.out = tw;
                try {
                    if (tc == null || tc.onStart() != 0) {
                        do {
                            if (element == null) continue;
                            this.visit(element);
                        } while (tc != null && tc.afterBody() == 0);
                    }
                }
                catch (Throwable t) {
                    try {
                        if (tc != null) {
                            tc.onError(t);
                            break block17;
                        }
                        throw t;
                    }
                    catch (TemplateException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new UndeclaredThrowableException(e);
                    }
                }
                finally {
                    this.out = prevOut;
                    tw.close();
                }
            }
            catch (TemplateException te) {
                this.handleTemplateException(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(Macro.Context mctxt) throws TemplateException, IOException {
        block5: {
            Macro.Context previousMacroContext = this.currentMacroContext;
            this.currentMacroContext = mctxt;
            ArrayList prevLocalContextStack = this.localContextStack;
            this.localContextStack = null;
            Namespace prevNamespace = this.currentNamespace;
            this.currentNamespace = this.getMacroNamespace(mctxt.getMacro());
            try {
                try {
                    mctxt.runMacro(this);
                }
                catch (BreakInstruction.Return re) {
                    Object var7_6 = null;
                    this.currentMacroContext = previousMacroContext;
                    this.localContextStack = prevLocalContextStack;
                    this.currentNamespace = prevNamespace;
                    break block5;
                }
                catch (TemplateException te) {
                    this.handleTemplateException(te);
                    Object var7_7 = null;
                    this.currentMacroContext = previousMacroContext;
                    this.localContextStack = prevLocalContextStack;
                    this.currentNamespace = prevNamespace;
                }
                Object var7_5 = null;
                this.currentMacroContext = previousMacroContext;
                this.localContextStack = prevLocalContextStack;
                this.currentNamespace = prevNamespace;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.currentMacroContext = previousMacroContext;
                this.localContextStack = prevLocalContextStack;
                this.currentNamespace = prevNamespace;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(BodyInstruction.Context bctxt) throws TemplateException, IOException {
        Macro.Context invokingMacroContext = this.getCurrentMacroContext();
        ArrayList prevLocalContextStack = this.getCurrentLocalContextStack();
        TemplateElement body = invokingMacroContext.body;
        if (body != null) {
            this.setCurrentMacroContext(invokingMacroContext.prevMacroContext);
            this.setCurrentNamespace(invokingMacroContext.bodyNamespace);
            this.setCurrentLocalContextStack(invokingMacroContext.prevLocalContextStack);
            if (invokingMacroContext.bodyParameterNames != null) {
                this.pushLocalContext(bctxt);
            }
            try {
                this.visit(body);
                Object var6_5 = null;
                if (invokingMacroContext.bodyParameterNames != null) {
                    this.popLocalContext();
                }
                this.setCurrentMacroContext(invokingMacroContext);
                this.setCurrentNamespace(this.getMacroNamespace(invokingMacroContext.getMacro()));
                this.setCurrentLocalContextStack(prevLocalContextStack);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (invokingMacroContext.bodyParameterNames != null) {
                    this.popLocalContext();
                }
                this.setCurrentMacroContext(invokingMacroContext);
                this.setCurrentNamespace(this.getMacroNamespace(invokingMacroContext.getMacro()));
                this.setCurrentLocalContextStack(prevLocalContextStack);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(IteratorBlock.Context ictxt) throws TemplateException, IOException {
        this.pushLocalContext(ictxt);
        try {
            ictxt.runLoop(this);
        }
        catch (BreakInstruction.Break br) {
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popLocalContext();
        }
    }

    void visitMacroDef(Macro macro) {
        this.macroToNamespaceLookup.put(macro, this.currentNamespace);
        this.currentNamespace.put(macro.getMacroName(), macro);
    }

    Namespace getMacroNamespace(Macro macro) {
        return (Namespace)this.macroToNamespaceLookup.get(macro);
    }

    Macro.Context getCurrentMacroContext() {
        return this.currentMacroContext;
    }

    void setCurrentMacroContext(Macro.Context macroContext) {
        this.currentMacroContext = macroContext;
    }

    ArrayList getCurrentLocalContextStack() {
        return this.localContextStack;
    }

    void setCurrentLocalContextStack(ArrayList localContextStack) {
        this.localContextStack = localContextStack;
    }

    private void handleTemplateException(TemplateException te) throws TemplateException {
        if (this.lastThrowable == te) {
            throw te;
        }
        this.lastThrowable = te;
        if (logger.isErrorEnabled()) {
            logger.error("", te);
        }
        if (te instanceof StopException) {
            throw te;
        }
        this.getTemplateExceptionHandler().handleTemplateException(te, this, this.out);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
        this.collator = null;
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
    }

    Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
        }
        return this.collator;
    }

    Writer getOut() {
        return this.out;
    }

    String formatNumber(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = this.getNumberFormatObject(this.getNumberFormat());
        }
        return this.numberFormat.format(number);
    }

    public void setNumberFormat(String formatName) {
        super.setNumberFormat(formatName);
        this.numberFormat = null;
    }

    String formatDate(Date date, int type) throws TemplateModelException {
        DateFormat df = this.getDateFormatObject(type);
        if (df == null) {
            throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
        }
        return df.format(date);
    }

    public void setTimeFormat(String formatName) {
        super.setTimeFormat(formatName);
        this.timeFormat = null;
    }

    public void setDateFormat(String formatName) {
        super.setDateFormat(formatName);
        this.dateFormat = null;
    }

    public void setDateTimeFormat(String formatName) {
        super.setDateTimeFormat(formatName);
        this.dateTimeFormat = null;
    }

    Configuration getConfiguration() {
        return this.getTemplate().getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NumberFormat getNumberFormatObject(String pattern) {
        NumberFormat format;
        if (this.numberFormats == null) {
            this.numberFormats = new HashMap();
        }
        if ((format = (NumberFormat)this.numberFormats.get(pattern)) != null) {
            return format;
        }
        Map map = localizedNumberFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            NumberFormatKey fk = new NumberFormatKey(pattern, locale);
            format = (NumberFormat)localizedNumberFormats.get(fk);
            if (format == null) {
                format = "number".equals(pattern) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(pattern) ? NumberFormat.getCurrencyInstance(locale) : ("percent".equals(pattern) ? NumberFormat.getPercentInstance(locale) : new DecimalFormat(pattern, new DecimalFormatSymbols(this.getLocale()))));
                localizedNumberFormats.put(fk, format);
            }
        }
        format = (NumberFormat)format.clone();
        this.numberFormats.put(pattern, format);
        return format;
    }

    DateFormat getDateFormatObject(int dateType) throws TemplateModelException {
        switch (dateType) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.timeFormat == null) {
                    this.timeFormat = this.getDateFormatObject(dateType, this.getTimeFormat());
                }
                return this.timeFormat;
            }
            case 2: {
                if (this.dateFormat == null) {
                    this.dateFormat = this.getDateFormatObject(dateType, this.getDateFormat());
                }
                return this.dateFormat;
            }
            case 3: {
                if (this.dateTimeFormat == null) {
                    this.dateTimeFormat = this.getDateFormatObject(dateType, this.getDateTimeFormat());
                }
                return this.dateTimeFormat;
            }
        }
        throw new TemplateModelException("Unrecognized date type " + dateType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateFormat getDateFormatObject(int dateType, String pattern) throws TemplateModelException {
        Map typedDateFormat;
        DateFormat format;
        if (this.dateFormats == null) {
            this.dateFormats = new Map[4];
            this.dateFormats[0] = new HashMap();
            this.dateFormats[1] = new HashMap();
            this.dateFormats[2] = new HashMap();
            this.dateFormats[3] = new HashMap();
        }
        if ((format = (DateFormat)(typedDateFormat = this.dateFormats[dateType]).get(pattern)) != null) {
            return format;
        }
        Map map = localizedDateFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            TimeZone timeZone = this.getTimeZone();
            DateFormatKey fk = new DateFormatKey(dateType, pattern, locale, timeZone);
            format = (DateFormat)localizedDateFormats.get(fk);
            if (format == null) {
                int style;
                StringTokenizer tok = new StringTokenizer(pattern, "_");
                int n = style = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : 2;
                if (style != -1) {
                    switch (dateType) {
                        case 0: {
                            throw new TemplateModelException("Can't convert the date to string using a built-in format, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(<format>) built-in with explicit formatting pattern with this date.");
                        }
                        case 1: {
                            format = DateFormat.getTimeInstance(style, locale);
                            break;
                        }
                        case 2: {
                            format = DateFormat.getDateInstance(style, locale);
                            break;
                        }
                        case 3: {
                            int timestyle;
                            int n2 = timestyle = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : style;
                            if (timestyle == -1) break;
                            format = DateFormat.getDateTimeInstance(style, timestyle, locale);
                            break;
                        }
                    }
                }
                if (format == null) {
                    try {
                        format = new SimpleDateFormat(pattern, locale);
                    }
                    catch (IllegalArgumentException e) {
                        throw new TemplateModelException("Can't parse " + pattern + " to a date format.", e);
                    }
                }
                format.setTimeZone(timeZone);
                localizedDateFormats.put(fk, format);
            }
        }
        format = (DateFormat)format.clone();
        typedDateFormat.put(pattern, format);
        return format;
    }

    int parseDateStyleToken(String token) {
        if ("short".equals(token)) {
            return 3;
        }
        if ("medium".equals(token)) {
            return 2;
        }
        if ("long".equals(token)) {
            return 1;
        }
        return -1;
    }

    TemplateTransformModel getTransform(Expression exp) throws TemplateException {
        TemplateTransformModel ttm = null;
        TemplateModel tm = exp.getAsTemplateModel(this);
        if (tm instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        } else if (exp instanceof Identifier && (tm = this.getConfiguration().getSharedVariable(exp.toString())) instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        }
        return ttm;
    }

    public TemplateModel getLocalVariable(String name) throws TemplateModelException {
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext lc = (LocalContext)this.localContextStack.get(i);
                TemplateModel tm = lc.getLocalVariable(name);
                if (tm == null) continue;
                return tm;
            }
        }
        return this.currentMacroContext == null ? null : this.currentMacroContext.getLocalVariable(name);
    }

    public TemplateModel getVariable(String name) throws TemplateModelException {
        TemplateModel result = this.getLocalVariable(name);
        if (result == null) {
            result = this.currentNamespace.get(name);
        }
        if (result == null) {
            result = this.getGlobalVariable(name);
        }
        return result;
    }

    public TemplateModel getGlobalVariable(String name) throws TemplateModelException {
        TemplateModel result = this.globalNamespace.get(name);
        if (result == null) {
            result = this.rootDataModel.get(name);
        }
        if (result == null) {
            result = this.getConfiguration().getSharedVariable(name);
        }
        return result;
    }

    public void setGlobalVariable(String name, TemplateModel model) {
        this.globalNamespace.put(name, model);
    }

    public void setVariable(String name, TemplateModel model) {
        this.currentNamespace.put(name, model);
    }

    public void setLocalVariable(String name, TemplateModel model) {
        if (this.currentMacroContext == null) {
            throw new IllegalStateException("Not executing macro body");
        }
        this.currentMacroContext.setLocalVar(name, model);
    }

    public Set getKnownVariableNames() throws TemplateModelException {
        Set set = this.getConfiguration().getSharedVariableNames();
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            TemplateModelIterator rootNames = ((TemplateHashModelEx)this.rootDataModel).keys().iterator();
            while (rootNames.hasNext()) {
                set.add(((TemplateScalarModel)rootNames.next()).getAsString());
            }
        }
        TemplateModelIterator tmi = this.globalNamespace.keys().iterator();
        while (tmi.hasNext()) {
            set.add(((TemplateScalarModel)tmi.next()).getAsString());
        }
        tmi = this.currentNamespace.keys().iterator();
        while (tmi.hasNext()) {
            set.add(((TemplateScalarModel)tmi.next()).getAsString());
        }
        if (this.currentMacroContext != null) {
            set.addAll(this.currentMacroContext.getLocalVariableNames());
        }
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext lc = (LocalContext)this.localContextStack.get(i);
                set.addAll(lc.getLocalVariableNames());
            }
        }
        return set;
    }

    public void outputInstructionStack(PrintWriter pw) {
        TemplateElement prev;
        pw.println("----------");
        ListIterator iter = this.elementStack.listIterator(this.elementStack.size());
        if (iter.hasPrevious()) {
            pw.print("==> ");
            prev = (TemplateElement)iter.previous();
            pw.print(prev.getDescription());
            pw.print(" [");
            pw.print(prev.getStartLocation());
            pw.println("]");
        }
        while (iter.hasPrevious()) {
            String location;
            prev = (TemplateElement)iter.previous();
            if (!(prev instanceof UnifiedCall) && !(prev instanceof Include) || (location = prev.getDescription() + " [" + prev.getStartLocation() + "]") == null || location.length() <= 0) continue;
            pw.print(" in ");
            pw.println(location);
        }
        pw.println("----------");
        pw.flush();
    }

    private void pushLocalContext(LocalContext localContext) {
        if (this.localContextStack == null) {
            this.localContextStack = new ArrayList();
        }
        this.localContextStack.add(localContext);
    }

    private void popLocalContext() {
        this.localContextStack.remove(this.localContextStack.size() - 1);
    }

    public Namespace getNamespace(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.loadedLibs != null) {
            return (Namespace)this.loadedLibs.get(name);
        }
        return null;
    }

    public Namespace getMainNamespace() {
        return this.mainNamespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    public TemplateHashModel getDataModel() {
        return new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel result = Environment.this.rootDataModel.get(key);
                if (result == null) {
                    result = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return result;
            }
        };
    }

    public TemplateHashModel getGlobalVariables() {
        return new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel result = Environment.this.globalNamespace.get(key);
                if (result == null) {
                    result = Environment.this.rootDataModel.get(key);
                }
                if (result == null) {
                    result = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return result;
            }
        };
    }

    void setCurrentNamespace(Namespace namespace) {
        this.currentNamespace = namespace;
    }

    void pushNamespace(String name) {
        Namespace newNamespace = new Namespace();
        this.currentNamespace.put(name, newNamespace);
        if (this.currentNamespace == this.mainNamespace) {
            this.globalNamespace.put(name, newNamespace);
        }
        this.namespaceStack.add(newNamespace);
        this.currentNamespace = newNamespace;
    }

    void popNamespace() {
        int lastIndex = this.namespaceStack.size() - 1;
        this.namespaceStack.remove(lastIndex);
        this.currentNamespace = (Namespace)this.namespaceStack.get(lastIndex - 1);
    }

    private void pushElement(TemplateElement element) {
        this.elementStack.add(element);
    }

    private void popElement() {
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    public void include(String name, String encoding, boolean parse) throws IOException, TemplateException {
        if (encoding == null) {
            encoding = this.getTemplate().getEncoding();
        }
        if (encoding == null) {
            encoding = this.getConfiguration().getEncoding(this.getLocale());
        }
        Template includedTemplate = this.getConfiguration().getTemplate(name, this.getLocale(), encoding, parse);
        this.include(includedTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLib(String name, String namespace) throws IOException, TemplateException {
        String templateName;
        Namespace existingNamespace;
        String encoding = this.getTemplate().getEncoding();
        if (encoding == null) {
            encoding = this.getConfiguration().getEncoding(this.getLocale());
        }
        Template loadedTemplate = this.getConfiguration().getTemplate(name, this.getLocale(), encoding, true);
        if (this.loadedLibs == null) {
            this.loadedLibs = new HashMap();
        }
        if ((existingNamespace = (Namespace)this.loadedLibs.get(templateName = loadedTemplate.getName())) != null) {
            this.setVariable(namespace, existingNamespace);
        } else {
            this.pushNamespace(namespace);
            this.loadedLibs.put(templateName, this.currentNamespace);
            Writer prevOut = this.out;
            this.out = NULL_WRITER;
            try {
                this.include(loadedTemplate);
            }
            finally {
                this.out = prevOut;
                this.popNamespace();
            }
        }
    }

    void importMacros(Template template) {
        Iterator it = template.macros.values().iterator();
        while (it.hasNext()) {
            this.visitMacroDef((Macro)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Template includedTemplate) throws TemplateException, IOException {
        Template prevTemplate = this.getTemplate();
        this.setParent(includedTemplate);
        this.importMacros(includedTemplate);
        try {
            this.visit(includedTemplate.rootElement);
        }
        finally {
            this.setParent(prevTemplate);
        }
    }

    public Object __getitem__(String key) throws TemplateModelException {
        return BeansWrapper.getDefaultInstance().unwrap(this.getVariable(key));
    }

    public void __setitem__(String key, Object o) throws TemplateException {
        this.setGlobalVariable(key, BeansWrapper.getDefaultInstance().wrap(o));
    }

    public static class Namespace
    extends SimpleHash {
    }

    private static final class DateFormatKey {
        private final int dateType;
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;

        DateFormatKey(int dateType, String pattern, Locale locale, TimeZone timeZone) {
            this.dateType = dateType;
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public boolean equals(Object o) {
            if (o instanceof DateFormatKey) {
                DateFormatKey fk = (DateFormatKey)o;
                return this.dateType == fk.dateType && fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale) && fk.timeZone.equals(this.timeZone);
            }
            return false;
        }

        public int hashCode() {
            return this.dateType ^ this.pattern.hashCode() ^ this.locale.hashCode() ^ this.timeZone.hashCode();
        }
    }

    private static final class NumberFormatKey {
        private final String pattern;
        private final Locale locale;

        NumberFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (o instanceof NumberFormatKey) {
                NumberFormatKey fk = (NumberFormatKey)o;
                return fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode() ^ this.locale.hashCode();
        }
    }
}

