/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Configuration;
import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.ParseException;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

final class BuiltinVariable
extends Expression {
    public static final String NAMESPACE = "namespace";
    public static final String MAIN = "main";
    public static final String GLOBALS = "globals";
    public static final String LOCALS = "locals";
    public static final String DATA_MODEL = "data_model";
    public static final String LANG = "lang";
    public static final String LOCALE = "locale";
    public static final String VARS = "vars";
    public static final String VERSION = "version";
    private final String name;

    BuiltinVariable(String name) throws ParseException {
        this.name = name = name.intern();
        if (name != NAMESPACE && name != MAIN && name != GLOBALS && name != LOCALS && name != LANG && name != LOCALE && name != DATA_MODEL && name != VARS && name != VERSION) {
            throw new ParseException("Unknown built-in variable: " + name, this);
        }
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        if (this.name == NAMESPACE) {
            return env.getCurrentNamespace();
        }
        if (this.name == MAIN) {
            return env.getMainNamespace();
        }
        if (this.name == GLOBALS) {
            return env.getGlobalVariables();
        }
        if (this.name == LOCALS) {
            return env.getCurrentMacroContext().getLocals();
        }
        if (this.name == DATA_MODEL) {
            return env.getDataModel();
        }
        if (this.name == VARS) {
            return new VarsHash(env);
        }
        if (this.name == LOCALE) {
            return new SimpleScalar(env.getLocale().toString());
        }
        if (this.name == LANG) {
            return new SimpleScalar(env.getLocale().getLanguage());
        }
        if (this.name == VERSION) {
            return new SimpleScalar(Configuration.getVersionNumber());
        }
        throw new TemplateException("Invalid built-in variable: " + this, env);
    }

    public String toString() {
        return "." + this.name;
    }

    public String getCanonicalForm() {
        return "." + this.name;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name, Expression subst) {
        return this;
    }

    class VarsHash
    implements TemplateHashModel {
        Environment env;

        VarsHash(Environment env) {
            this.env = env;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            return this.env.getVariable(key);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

