/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.ext.jsp.EventForwarding;
import freemarker.ext.jsp.TagTransformModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.log.Logger;
import freemarker.template.Environment;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.ClassUtil;
import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TaglibFactory
implements TemplateHashModel {
    private static final Logger logger = Logger.getLogger("freemarker.jsp");
    private static final int LOOKUP_NONE = 0;
    private static final int LOOKUP_WEB_XML = 1;
    private static final int LOOKUP_JARS = 2;
    private final ServletContext ctx;
    private final Map taglibs = new HashMap();
    private final Map locations = new HashMap();
    private int lookupPhase = 0;
    static /* synthetic */ Class class$freemarker$ext$jsp$EventForwarding;

    public TaglibFactory(ServletContext ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModel get(String uri) throws TemplateModelException {
        uri = TaglibFactory.resolveRelativeUri(uri);
        Map map = this.taglibs;
        synchronized (map) {
            Taglib taglib = null;
            taglib = (Taglib)this.taglibs.get(uri);
            if (taglib != null) {
                return taglib;
            }
            taglib = new Taglib();
            try {
                do {
                    if (!taglib.load(uri, this.ctx, this.locations)) continue;
                    this.taglibs.put(uri, taglib);
                    return taglib;
                } while (this.getMoreTaglibLocations());
            }
            catch (TemplateModelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateModelException("Could not load taglib information", e);
            }
            return null;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    private boolean getMoreTaglibLocations() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        switch (this.lookupPhase) {
            case 0: {
                this.getLocationsFromWebXml();
                this.lookupPhase = 1;
                return true;
            }
            case 1: {
                this.getLocationsFromLibJars();
                this.lookupPhase = 2;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLocationsFromWebXml() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        WebXmlParser webXmlParser = new WebXmlParser(this.locations);
        InputStream in = this.ctx.getResourceAsStream("/WEB-INF/web.xml");
        if (in == null) {
            return;
        }
        try {
            TaglibFactory.parseXml(in, this.ctx.getResource("/WEB-INF/web.xml").toExternalForm(), webXmlParser);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLocationsFromLibJars() throws ParserConfigurationException, IOException, SAXException {
        Set libs = this.ctx.getResourcePaths("/WEB-INF/lib");
        Iterator iter = libs.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
            ZipInputStream zin = new ZipInputStream(this.ctx.getResourceAsStream(path));
            FilterInputStream uin = new FilterInputStream(zin){

                public void close() {
                }
            };
            try {
                ZipEntry ze;
                while ((ze = zin.getNextEntry()) != null) {
                    String url;
                    String loc;
                    String zname = ze.getName();
                    if (!zname.startsWith("META-INF/") || !zname.endsWith(".tld") || (loc = this.getTldUri(uin, url = "jar:" + this.ctx.getResource(path).toExternalForm() + "!" + zname)) == null) continue;
                    this.locations.put(loc, new String[]{path, zname});
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("libjar assigned URI " + loc + " to location " + path + "!" + zname);
                }
            }
            finally {
                zin.close();
            }
        }
    }

    private String getTldUri(InputStream in, String url) throws ParserConfigurationException, IOException, SAXException {
        TldUriReader tur = new TldUriReader();
        TaglibFactory.parseXml(in, url, tur);
        return tur.getUri();
    }

    private static void parseXml(InputStream in, String url, DefaultHandler handler) throws ParserConfigurationException, IOException, SAXException {
        InputSource is = new InputSource();
        is.setByteStream(in);
        is.setSystemId(url);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setEntityResolver(new FakeSunDtds());
        reader.setContentHandler(handler);
        reader.parse(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map loadTaglib(String[] tldPath, ServletContext ctx) throws ParserConfigurationException, IOException, SAXException, TemplateModelException {
        if (tldPath == null) {
            return null;
        }
        String filePath = tldPath[0];
        TldParser tldParser = new TldParser();
        InputStream in = ctx.getResourceAsStream(filePath);
        if (in == null) {
            throw new TemplateModelException("Could not find webapp resource " + filePath);
        }
        String url = ctx.getResource(filePath).toExternalForm();
        try {
            String jarPath = tldPath[1];
            if (jarPath != null) {
                ZipEntry ze;
                String zname;
                ZipInputStream zin = new ZipInputStream(in);
                do {
                    if ((ze = zin.getNextEntry()) != null) continue;
                    throw new TemplateModelException("Could not find JAR entry " + jarPath + " inside webapp resource " + filePath);
                } while (!(zname = ze.getName()).equals(jarPath));
                TaglibFactory.parseXml(zin, "jar:" + url + "!" + zname, tldParser);
            } else {
                TaglibFactory.parseXml(in, url, tldParser);
            }
        }
        finally {
            in.close();
        }
        EventForwarding eventForwarding = EventForwarding.getInstance(ctx);
        if (eventForwarding != null) {
            eventForwarding.addListeners(tldParser.getListeners());
        } else if (tldParser.getListeners().size() > 0) {
            throw new TemplateModelException("Event listeners specified in the TLD could not be  registered since the web application doesn't have a listener of class " + (class$freemarker$ext$jsp$EventForwarding == null ? (class$freemarker$ext$jsp$EventForwarding = TaglibFactory.class$("freemarker.ext.jsp.EventForwarding")) : class$freemarker$ext$jsp$EventForwarding).getName() + ". To remedy this, add this element to web.xml:\n" + "| <listener>\n" + "|   <listener-class>" + (class$freemarker$ext$jsp$EventForwarding == null ? (class$freemarker$ext$jsp$EventForwarding = TaglibFactory.class$("freemarker.ext.jsp.EventForwarding")) : class$freemarker$ext$jsp$EventForwarding).getName() + "</listener-class>\n" + "| </listener>");
        }
        return tldParser.getTags();
    }

    private static final String[] getTldPath(String uri, Map locations) {
        String[] path = (String[])locations.get(uri);
        if (path != null) {
            return path;
        }
        if (uri.startsWith("/")) {
            path = new String[2];
            path[0] = uri;
            if (uri.endsWith(".jar") || uri.endsWith(".zip")) {
                path[1] = "META-INF/taglib.tld";
            }
            return path;
        }
        return null;
    }

    private static String resolveRelativeUri(String uri) throws TemplateModelException {
        if (uri.startsWith("/") || uri.indexOf("://") != -1) {
            return uri;
        }
        TemplateModel reqHash = Environment.getCurrentEnvironment().getVariable("Request");
        if (reqHash instanceof HttpRequestHashModel) {
            int lastSlash;
            HttpServletRequest req = ((HttpRequestHashModel)reqHash).getRequest();
            String pi = req.getPathInfo();
            String reqPath = req.getServletPath();
            if (reqPath == null) {
                reqPath = "";
            }
            if ((lastSlash = (reqPath = reqPath + (pi == null ? "" : pi)).lastIndexOf(47)) != -1) {
                return reqPath.substring(0, lastSlash + 1) + uri;
            }
            return '/' + uri;
        }
        throw new TemplateModelException("Can't resolve relative URI " + uri + " as request URL information is unavailable.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class FakeSunDtds
    implements EntityResolver {
        private FakeSunDtds() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (publicId != null && publicId.startsWith("-//Sun Microsystems, Inc.//DTD") || systemId != null && systemId.startsWith("http://java.sun.com/j2ee/dtds/") || systemId != null && systemId.startsWith("http://java.sun.com/dtd/")) {
                InputSource is = new InputSource();
                is.setPublicId(publicId);
                is.setSystemId(systemId);
                is.setByteStream(new ByteArrayInputStream(new byte[0]));
                return is;
            }
            return null;
        }
    }

    private static final class TldParser
    extends DefaultHandler {
        private final Map tags = new HashMap();
        private final List listeners = new ArrayList();
        private Locator locator;
        private StringBuffer buf;
        private String tagName;
        private String tagClass;

        private TldParser() {
        }

        Map getTags() {
            return this.tags;
        }

        List getListeners() {
            return this.listeners;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String nsuri, String localName, String qName, Attributes atts) {
            if ("name".equals(qName) || "tagclass".equals(qName) || "tag-class".equals(qName) || "listener-class".equals(qName)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] chars, int off, int len) {
            if (this.buf != null) {
                this.buf.append(chars, off, len);
            }
        }

        public void endElement(String nsuri, String localName, String qName) throws SAXParseException {
            if ("name".equals(qName)) {
                if (this.tagName == null) {
                    this.tagName = this.buf.toString().trim();
                }
                this.buf = null;
            } else if ("tagclass".equals(qName) || "tag-class".equals(qName)) {
                this.tagClass = this.buf.toString().trim();
                this.buf = null;
            } else {
                if ("tag".equals(qName)) {
                    try {
                        this.tags.put(this.tagName, new TagTransformModel(ClassUtil.forName(this.tagClass)));
                        this.tagName = null;
                        this.tagClass = null;
                    }
                    catch (IntrospectionException e) {
                        throw new SAXParseException("Can't introspect tag class " + this.tagClass, this.locator, e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new SAXParseException("Can't find tag class " + this.tagClass, this.locator, e);
                    }
                }
                if ("listener-class".equals(qName)) {
                    String listenerClass = this.buf.toString().trim();
                    this.buf = null;
                    try {
                        this.listeners.add(ClassUtil.forName(listenerClass).newInstance());
                    }
                    catch (Exception e) {
                        throw new SAXParseException("Can't instantiate listener class " + listenerClass, this.locator, e);
                    }
                }
            }
        }
    }

    private static final class Taglib
    implements TemplateHashModel {
        private Map tags;

        Taglib() {
        }

        public TemplateModel get(String key) {
            return (TagTransformModel)this.tags.get(key);
        }

        public boolean isEmpty() {
            return false;
        }

        boolean load(String uri, ServletContext ctx, Map locations) throws ParserConfigurationException, IOException, SAXException, TemplateModelException {
            String[] tldPath = TaglibFactory.getTldPath(uri, locations);
            if (logger.isDebugEnabled()) {
                if (tldPath == null) {
                    logger.debug("Loading taglib " + uri + " from location null");
                } else {
                    logger.debug("Loading taglib " + uri + " from location " + tldPath[0] + (tldPath[1] != null ? "!" + tldPath[1] : ""));
                }
            }
            this.tags = TaglibFactory.loadTaglib(tldPath, ctx);
            if (this.tags != null) {
                locations.remove(uri);
                return true;
            }
            return false;
        }
    }

    private static class TldUriReader
    extends DefaultHandler {
        private StringBuffer buf;
        private String uri;

        TldUriReader() {
        }

        String getUri() {
            return this.uri;
        }

        public void startElement(String nsuri, String localName, String qName, Attributes atts) {
            if ("uri".equals(qName)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] chars, int off, int len) {
            if (this.buf != null) {
                this.buf.append(chars, off, len);
            }
        }

        public void endElement(String nsuri, String localName, String qName) {
            if ("uri".equals(qName)) {
                this.uri = this.buf.toString().trim();
                this.buf = null;
            }
        }
    }

    private static class WebXmlParser
    extends DefaultHandler {
        private final Map locations;
        private StringBuffer buf;
        private String uri;
        private String location;

        WebXmlParser(Map locations) {
            this.locations = locations;
        }

        public void startElement(String nsuri, String localName, String qName, Attributes atts) {
            if ("taglib-uri".equals(qName) || "taglib-location".equals(qName)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] chars, int off, int len) {
            if (this.buf != null) {
                this.buf.append(chars, off, len);
            }
        }

        public void endElement(String nsuri, String localName, String qName) {
            if ("taglib-uri".equals(qName)) {
                this.uri = this.buf.toString().trim();
                this.buf = null;
            } else if ("taglib-location".equals(qName)) {
                this.location = this.buf.toString().trim();
                if (this.location.indexOf("://") == -1 && !this.location.startsWith("/")) {
                    this.location = "/WEB-INF/" + this.location;
                }
                this.buf = null;
            } else if ("taglib".equals(qName)) {
                String[] loc = new String[2];
                loc[0] = this.location;
                if (this.location.endsWith(".jar") || this.location.endsWith(".zip")) {
                    loc[1] = "META-INF/taglib.tld";
                }
                this.locations.put(this.uri, loc);
                if (logger.isDebugEnabled()) {
                    logger.debug("web.xml assigned URI " + this.uri + " to location " + loc[0] + (loc[1] != null ? "!" + loc[1] : ""));
                }
            }
        }
    }
}

