/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Configurable;
import freemarker.template.Configuration;
import freemarker.template.Environment;
import freemarker.template.FMParser;
import freemarker.template.Macro;
import freemarker.template.ObjectWrapper;
import freemarker.template.ParseException;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TextBlock;
import freemarker.template.TokenMgrError;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreePath;

public class Template
extends Configurable {
    final Map macros = new HashMap();
    final Map headerParams = new HashMap();
    TemplateElement rootElement;
    private String encoding;
    private final String name;
    private final ArrayList lines = new ArrayList();

    private Template(String name, Configuration cfg) {
        super(cfg != null ? cfg : Configuration.getDefaultConfiguration());
        this.name = name;
    }

    public Template(String name, Reader reader, Configuration cfg, String encoding) throws IOException {
        this(name, cfg);
        this.encoding = encoding;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader, 4096);
        }
        LineTableBuilder ltb = new LineTableBuilder(reader);
        try {
            FMParser parser = new FMParser(this, ltb, this.getConfiguration().getStrictSyntaxMode(), this.getConfiguration().getWhitespaceStripping());
            this.rootElement = parser.Root();
        }
        catch (TokenMgrError exc) {
            throw new ParseException("Token manager error: " + exc, 0, 0);
        }
        finally {
            ltb.close();
        }
    }

    public Template(String name, Reader reader, Configuration cfg) throws IOException {
        this(name, reader, cfg, null);
    }

    public Template(String name, Reader reader) throws IOException {
        this(name, reader, null);
    }

    Template(String name, TemplateElement root, Configuration config) {
        this(name, config);
        this.rootElement = root;
    }

    public static Template getPlainTextTemplate(String name, String content, Configuration config) {
        Template template = new Template(name, config);
        TextBlock block = new TextBlock(content);
        template.rootElement = block;
        return template;
    }

    public static Map getHeaderParameters(InputStream is) {
        try {
            return new FMParser(is).HeaderElement();
        }
        catch (ParseException pe) {
            return null;
        }
        catch (TokenMgrError exc) {
            return null;
        }
    }

    public static String getSpecifiedEncoding(InputStream is) {
        Map params = Template.getHeaderParameters(is);
        return params != null ? (String)params.get("encoding") : null;
    }

    public void process(Object rootMap, Writer out) throws TemplateException, IOException {
        this.createProcessingEnvironment(rootMap, out, null).process();
    }

    public void process(Object rootMap, Writer out, ObjectWrapper wrapper) throws TemplateException, IOException {
        this.createProcessingEnvironment(rootMap, out, wrapper).process();
    }

    public Environment createProcessingEnvironment(Object rootMap, Writer out, ObjectWrapper wrapper) throws TemplateException, IOException {
        TemplateHashModel root = null;
        if (rootMap instanceof TemplateHashModel) {
            root = (TemplateHashModel)rootMap;
        } else {
            if (wrapper == null) {
                wrapper = this.getObjectWrapper();
            }
            try {
                TemplateHashModel templateHashModel = root = rootMap != null ? (TemplateHashModel)wrapper.wrap(rootMap) : new SimpleHash(wrapper);
                if (root == null) {
                    throw new IllegalArgumentException(wrapper.getClass().getName() + " converted " + rootMap.getClass().getName() + " to null.");
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(wrapper.getClass().getName() + " could not convert " + rootMap.getClass().getName() + " to a TemplateHashModel.");
            }
        }
        Environment env = new Environment(this, root, out);
        this.getConfiguration().doAutoImports(env);
        this.getConfiguration().doAutoIncludes(env);
        return env;
    }

    public Environment createProcessingEnvironment(Object rootMap, Writer out) throws TemplateException, IOException {
        return this.createProcessingEnvironment(rootMap, out, null);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.dump(sw);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        return sw.toString();
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return (Configuration)this.getParent();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getHeaderParameter(String key) {
        return (String)this.headerParams.get(key);
    }

    void setHeaderParameters(Map params) {
        this.headerParams.putAll(params);
    }

    public void dump(PrintStream ps) {
        ps.print(this.rootElement.getCanonicalForm());
    }

    public void dump(Writer out) throws IOException {
        out.write(this.rootElement.getCanonicalForm());
    }

    void addMacro(Macro macro) {
        this.macros.put(macro.getMacroName(), macro);
    }

    public String getSource(int beginColumn, int beginLine, int endColumn, int endLine) {
        --beginColumn;
        --endColumn;
        --endLine;
        StringBuffer buf = new StringBuffer();
        for (int i = --beginLine; i <= endLine; ++i) {
            if (i >= this.lines.size()) continue;
            buf.append(this.lines.get(i));
        }
        int lastLineLength = this.lines.get(endLine).toString().length();
        int trailingCharsToDelete = lastLineLength - endColumn - 1;
        buf.delete(0, beginColumn);
        buf.delete(buf.length() - trailingCharsToDelete, buf.length());
        return buf.toString();
    }

    public TemplateElement getRootTreeNode() {
        return this.rootElement;
    }

    public TreePath containingElements(int column, int line) {
        ArrayList<TemplateElement> elements = new ArrayList<TemplateElement>();
        TemplateElement element = this.rootElement;
        block0: while (element.contains(column, line)) {
            elements.add(element);
            Enumeration enumeration = element.children();
            while (enumeration.hasMoreElements()) {
                TemplateElement elem = (TemplateElement)enumeration.nextElement();
                if (!elem.contains(column, line)) continue;
                element = elem;
                continue block0;
            }
            break block0;
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return new TreePath(elements.toArray());
    }

    public static class WrongEncodingException
    extends ParseException {
        public String specifiedEncoding;

        public WrongEncodingException(String specifiedEncoding) {
            this.specifiedEncoding = specifiedEncoding;
        }
    }

    private class LineTableBuilder
    extends FilterReader {
        StringBuffer lineBuf = new StringBuffer();
        int lastChar;

        LineTableBuilder(Reader r) {
            super(r);
        }

        public int read() throws IOException {
            int c = this.in.read();
            this.handleChar(c);
            return c;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int numchars = this.in.read(cbuf, off, len);
            for (int i = off; i < off + numchars; ++i) {
                char c = cbuf[i];
                this.handleChar(c);
            }
            return numchars;
        }

        public void close() throws IOException {
            if (this.lineBuf.length() > 0) {
                Template.this.lines.add(this.lineBuf.toString());
                this.lineBuf.setLength(0);
            }
            super.close();
        }

        private void handleChar(int c) {
            if (c == 10 || c == 13) {
                if (this.lastChar == 13 && c == 10) {
                    int lastIndex = Template.this.lines.size() - 1;
                    String lastLine = (String)Template.this.lines.get(lastIndex);
                    Template.this.lines.set(lastIndex, lastLine + '\n');
                } else {
                    this.lineBuf.append((char)c);
                    Template.this.lines.add(this.lineBuf.toString());
                    this.lineBuf.setLength(0);
                }
            } else if (c == 9) {
                int numSpaces = 8 - this.lineBuf.length() % 8;
                for (int i = 0; i < numSpaces; ++i) {
                    this.lineBuf.append(' ');
                }
            } else {
                this.lineBuf.append((char)c);
            }
            this.lastChar = c;
        }
    }
}

