/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.EvaluationUtil;
import freemarker.template.Expression;
import freemarker.template.NonBooleanException;
import freemarker.template.NumericalRange;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

final class Range
extends Expression {
    final Expression left;
    final Expression right;

    Range(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        return new NumericalRange(EvaluationUtil.getNumber(this.left, env).intValue(), EvaluationUtil.getNumber(this.right, env).intValue());
    }

    boolean isTrue(Environment env) throws TemplateException {
        String msg = "Error " + this.getStartLocation() + ". " + "\nExpecting a boolean here." + " Expression " + this + " is a range.";
        throw new NonBooleanException(msg, env);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + ".." + this.right.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new Range(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

