/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.LocalContext;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateObject;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

final class IteratorBlock
extends TemplateElement {
    private Expression listExpression;
    private String indexName;
    private boolean isForEach;

    IteratorBlock(Expression listExpression, String indexName, TemplateElement nestedBlock, boolean isForEach) {
        this.listExpression = listExpression;
        this.indexName = indexName;
        this.isForEach = isForEach;
        this.nestedBlock = nestedBlock;
    }

    void accept(Environment env) throws TemplateException, IOException {
        TemplateModel baseModel = this.listExpression.getAsTemplateModel(env);
        if (baseModel == null) {
            if (env.isClassicCompatible()) {
                return;
            }
            IteratorBlock.assertNonNull(baseModel, this.listExpression, env);
        }
        env.visit(new Context());
    }

    public String getCanonicalForm() {
        if (this.isForEach) {
            StringBuffer buf = new StringBuffer("<#foreach ");
            buf.append(this.indexName);
            buf.append(" in ");
            buf.append(this.listExpression.getCanonicalForm());
            buf.append(">");
            if (this.nestedBlock != null) {
                buf.append(this.nestedBlock.getCanonicalForm());
            }
            buf.append("</#foreach>");
            return buf.toString();
        }
        StringBuffer buf = new StringBuffer("<#list ");
        buf.append(this.listExpression.getCanonicalForm());
        buf.append(" as ");
        buf.append(this.indexName);
        buf.append(">");
        if (this.nestedBlock != null) {
            buf.append(this.nestedBlock.getCanonicalForm());
        }
        buf.append("</#list>");
        return buf.toString();
    }

    public String getDescription() {
        if (this.isForEach) {
            return "foreach " + this.indexName + " in " + this.listExpression;
        }
        return "list " + this.listExpression + " as " + this.indexName;
    }

    class Context
    implements LocalContext {
        private boolean hasNext;
        private TemplateModel loopVar;
        private int index;
        private Set variableNames = null;

        Context() {
        }

        void runLoop(Environment env) throws TemplateException, IOException {
            TemplateModel list = IteratorBlock.this.listExpression.getAsTemplateModel(env);
            if (list instanceof TemplateCollectionModel) {
                TemplateCollectionModel baseListModel = (TemplateCollectionModel)list;
                TemplateModelIterator it = baseListModel.iterator();
                this.hasNext = it.hasNext();
                while (this.hasNext) {
                    this.loopVar = it.next();
                    this.hasNext = it.hasNext();
                    if (IteratorBlock.this.nestedBlock != null) {
                        env.visit(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (list instanceof TemplateSequenceModel) {
                TemplateSequenceModel tsm = (TemplateSequenceModel)list;
                int size = tsm.size();
                this.index = 0;
                while (this.index < size) {
                    this.loopVar = tsm.get(this.index);
                    boolean bl = this.hasNext = size > this.index + 1;
                    if (IteratorBlock.this.nestedBlock != null) {
                        env.visit(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (env.isClassicCompatible()) {
                this.loopVar = list;
                if (IteratorBlock.this.nestedBlock != null) {
                    env.visit(IteratorBlock.this.nestedBlock);
                }
            } else {
                throw TemplateObject.invalidTypeException(list, IteratorBlock.this.listExpression, env, "collection or sequence");
            }
        }

        public TemplateModel getLocalVariable(String name) {
            if (name.startsWith(IteratorBlock.this.indexName)) {
                switch (name.length() - IteratorBlock.this.indexName.length()) {
                    case 0: {
                        return this.loopVar;
                    }
                    case 6: {
                        if (!name.endsWith("_index")) break;
                        return new SimpleNumber(this.index);
                    }
                    case 9: {
                        if (!name.endsWith("_has_next")) break;
                        return this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                    }
                }
            }
            return null;
        }

        public Set getLocalVariableNames() {
            if (this.variableNames == null) {
                this.variableNames = new HashSet();
                this.variableNames.add(IteratorBlock.this.indexName);
                this.variableNames.add(IteratorBlock.this.indexName + "_index");
                this.variableNames.add(IteratorBlock.this.indexName + "_has_next");
            }
            return this.variableNames;
        }
    }
}

