/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.StopException;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;

final class BreakInstruction
extends TemplateElement {
    static final int BREAK = 0;
    static final int RETURN = 1;
    static final int STOP = 2;
    static final String[] names = new String[]{"break", "return", "stop"};
    private int type;
    private Expression exp;

    BreakInstruction(int type) {
        this.type = type;
    }

    BreakInstruction(Expression exp) {
        this.exp = exp;
        this.type = 2;
    }

    void accept(Environment env) throws TemplateException {
        if (this.type == 0) {
            throw new Break();
        }
        if (this.type == 1) {
            throw new Return();
        }
        if (this.exp == null) {
            throw new StopException(env);
        }
        throw new StopException(env, this.exp.getStringValue(env));
    }

    public String getCanonicalForm() {
        if (this.type == 0) {
            return "<#break/>";
        }
        if (this.type == 1) {
            return "<#return/>";
        }
        String expString = this.exp == null ? "" : " " + this.exp.getCanonicalForm();
        return "<#stop" + expString + "/>";
    }

    public String getDescription() {
        return names[this.type] + " [" + this.getStartLocation() + "]";
    }

    static class Return
    extends RuntimeException {
        Return() {
        }
    }

    static class Break
    extends RuntimeException {
        Break() {
        }
    }
}

