/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.BooleanExpression;
import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.TemplateException;

final class AndExpression
extends BooleanExpression {
    private final Expression left;
    private final Expression right;

    AndExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    boolean isTrue(Environment env) throws TemplateException {
        return this.left.isTrue(env) && this.right.isTrue(env);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + " && " + this.right.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new AndExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

