/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ArithmeticEngine;
import freemarker.template.Environment;
import freemarker.template.EvaluationUtil;
import freemarker.template.Expression;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateSequenceModel;

final class AddConcatExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    AddConcatExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        String s2;
        TemplateModel leftModel = this.left.getAsTemplateModel(env);
        TemplateModel rightModel = this.right.getAsTemplateModel(env);
        if (leftModel instanceof TemplateNumberModel && rightModel instanceof TemplateNumberModel) {
            Number first = EvaluationUtil.getNumber((TemplateNumberModel)leftModel, this.left, env);
            Number second = EvaluationUtil.getNumber((TemplateNumberModel)rightModel, this.right, env);
            ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
            return new SimpleNumber(ae.add(first, second));
        }
        if (leftModel instanceof TemplateSequenceModel && rightModel instanceof TemplateSequenceModel) {
            return new ConcatenatedSequence((TemplateSequenceModel)leftModel, (TemplateSequenceModel)rightModel);
        }
        String s1 = AddConcatExpression.getStringValue(leftModel, this.left, env);
        if (s1 == null) {
            s1 = "null";
        }
        if ((s2 = AddConcatExpression.getStringValue(rightModel, this.right, env)) == null) {
            s2 = "null";
        }
        return new SimpleScalar(s1.concat(s2));
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new AddConcatExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + " + " + this.right.getCanonicalForm();
    }

    private static final class ConcatenatedSequence
    implements TemplateSequenceModel {
        private final TemplateSequenceModel left;
        private final TemplateSequenceModel right;

        ConcatenatedSequence(TemplateSequenceModel left, TemplateSequenceModel right) {
            this.left = left;
            this.right = right;
        }

        public int size() throws TemplateModelException {
            return this.left.size() + this.right.size();
        }

        public TemplateModel get(int i) throws TemplateModelException {
            int ls = this.left.size();
            return i < ls ? this.left.get(i) : this.right.get(i - ls);
        }
    }
}

