/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.SoftCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.utility.SecurityUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class TemplateCache {
    private static final String ASTERISKSTR = "*";
    private static final String LOCALE_SEPARATOR = "_";
    private static final char ASTERISK = '*';
    private static final String CURRENT_DIR_PATH_PREFIX = "./";
    private static final String CURRENT_DIR_PATH = "/./";
    private static final String PARENT_DIR_PATH_PREFIX = "../";
    private static final String PARENT_DIR_PATH = "/../";
    private static final char SLASH = '/';
    private static final Logger logger = Logger.getLogger("freemarker.cache");
    private final TemplateLoader loader;
    private final CacheStorage storage;
    private long delay = 5000L;
    private boolean localizedLookup = true;
    private Configuration config;
    static /* synthetic */ Class class$freemarker$cache$TemplateCache;

    public TemplateCache() {
        this(TemplateCache.createDefaultTemplateLoader());
    }

    private static TemplateLoader createDefaultTemplateLoader() {
        ClassTemplateLoader ctl = new ClassTemplateLoader(class$freemarker$cache$TemplateCache == null ? (class$freemarker$cache$TemplateCache = TemplateCache.class$("freemarker.cache.TemplateCache")) : class$freemarker$cache$TemplateCache, "/");
        try {
            return new MultiTemplateLoader(new TemplateLoader[]{new FileTemplateLoader(), ctl});
        }
        catch (Exception e) {
            logger.info("Could not create default file template loader for ${user.dir}=" + SecurityUtilities.getSystemProperty("user.dir"));
            return ctl;
        }
    }

    public TemplateCache(TemplateLoader loader) {
        this(loader, new SoftCacheStorage());
    }

    public TemplateCache(TemplateLoader loader, CacheStorage storage) {
        if (loader == null) {
            throw new IllegalArgumentException("loader == null");
        }
        this.loader = loader;
        if (storage == null) {
            throw new IllegalArgumentException("storage == null");
        }
        this.storage = storage;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.clear();
    }

    public TemplateLoader getTemplateLoader() {
        return this.loader;
    }

    public CacheStorage getCacheStorage() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Template getTemplate(String name, Locale locale, String encoding, boolean parse) throws IOException {
        String debugName;
        boolean debug = logger.isDebugEnabled();
        String string = debug ? name + "[" + locale + "," + encoding + (parse ? ",parsed] " : ",unparsed] ") : (debugName = null);
        if (name == null) {
            throw new IllegalArgumentException("Argument \"name\" can't be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument \"locale\" can't be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument \"encoding\" can't be null");
        }
        if ((name = TemplateCache.normalizeName(name)) == null) {
            return null;
        }
        TemplateKey tk = new TemplateKey(name, locale, encoding, parse);
        CacheStorage cacheStorage = this.storage;
        synchronized (cacheStorage) {
            Template template;
            Object newlyFoundSource;
            block26: {
                Template lastModifiedNotChanged2;
                block25: {
                    Template template2;
                    block24: {
                        Template template3;
                        block23: {
                            Template template4;
                            block22: {
                                CachedTemplate cachedTemplate = (CachedTemplate)this.storage.get(tk);
                                long now = System.currentTimeMillis();
                                long lastModified = -1L;
                                newlyFoundSource = null;
                                try {
                                    if (cachedTemplate != null) {
                                        if (now - cachedTemplate.lastChecked < this.delay) {
                                            if (debug) {
                                                logger.debug(debugName + "cached copy not yet stale; using cached.");
                                            }
                                            template4 = cachedTemplate.template;
                                            Object var19_18 = null;
                                            if (newlyFoundSource == null) return template4;
                                            break block22;
                                        }
                                        cachedTemplate.lastChecked = now;
                                        newlyFoundSource = this.findTemplateSource(name, locale);
                                        if (newlyFoundSource == null) {
                                            if (debug) {
                                                logger.debug(debugName + "no source found (removing from cache if it was cached).");
                                            }
                                            this.storage.remove(tk);
                                            template3 = null;
                                            break block23;
                                        }
                                        lastModified = this.loader.getLastModified(newlyFoundSource);
                                        boolean lastModifiedNotChanged2 = lastModified == cachedTemplate.lastModified;
                                        boolean sourceEquals = newlyFoundSource.equals(cachedTemplate.source);
                                        if (lastModifiedNotChanged2 && sourceEquals) {
                                            if (debug) {
                                                logger.debug(debugName + "using cached since " + newlyFoundSource + " didn't change.");
                                            }
                                            cachedTemplate.lastChecked = now;
                                            template2 = cachedTemplate.template;
                                            break block24;
                                        }
                                        if (debug && !sourceEquals) {
                                            logger.debug("Updating source, info for cause: sourceEquals=" + sourceEquals + ", newlyFoundSource=" + newlyFoundSource + ", cachedTemplate.source=" + cachedTemplate.source);
                                        }
                                        if (debug && !lastModifiedNotChanged2) {
                                            logger.debug("Updating source, info for cause: lastModifiedNotChanged=" + lastModifiedNotChanged2 + ", cache lastModified=" + cachedTemplate.lastModified + " != file lastModified=" + lastModified);
                                        }
                                        cachedTemplate.source = newlyFoundSource;
                                    } else {
                                        if (debug) {
                                            logger.debug("Could not find template in cache, creating new one; id=[" + tk.name + "[" + tk.locale + "," + tk.encoding + (tk.parse ? ",parsed] " : ",unparsed] ") + "]");
                                        }
                                        if ((newlyFoundSource = this.findTemplateSource(name, locale)) == null) {
                                            lastModifiedNotChanged2 = null;
                                            break block25;
                                        }
                                        cachedTemplate = new CachedTemplate();
                                        cachedTemplate.source = newlyFoundSource;
                                        cachedTemplate.lastChecked = now;
                                        lastModified = Long.MIN_VALUE;
                                        cachedTemplate.lastModified = Long.MIN_VALUE;
                                        this.storage.put(tk, cachedTemplate);
                                    }
                                    if (debug) {
                                        logger.debug("Compiling FreeMarker template " + debugName + " from " + newlyFoundSource);
                                    }
                                    Object source = cachedTemplate.source;
                                    cachedTemplate.template = this.loadTemplate(name, locale, encoding, parse, source);
                                    cachedTemplate.lastModified = lastModified == Long.MIN_VALUE ? this.loader.getLastModified(source) : lastModified;
                                    template = cachedTemplate.template;
                                    break block26;
                                }
                                catch (Throwable throwable) {
                                    Object var19_23 = null;
                                    if (newlyFoundSource == null) throw throwable;
                                    this.loader.closeTemplateSource(newlyFoundSource);
                                    throw throwable;
                                }
                            }
                            this.loader.closeTemplateSource(newlyFoundSource);
                            return template4;
                        }
                        Object var19_19 = null;
                        if (newlyFoundSource == null) return template3;
                        this.loader.closeTemplateSource(newlyFoundSource);
                        return template3;
                    }
                    Object var19_20 = null;
                    if (newlyFoundSource == null) return template2;
                    this.loader.closeTemplateSource(newlyFoundSource);
                    return template2;
                }
                Object var19_21 = null;
                if (newlyFoundSource == null) return lastModifiedNotChanged2;
                this.loader.closeTemplateSource(newlyFoundSource);
                return lastModifiedNotChanged2;
            }
            Object var19_22 = null;
            if (newlyFoundSource == null) return template;
            this.loader.closeTemplateSource(newlyFoundSource);
            return template;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template loadTemplate(String name, Locale locale, String encoding, boolean parse, Object source) throws IOException {
        Template template;
        Reader reader = this.loader.getReader(source, encoding);
        try {
            if (parse) {
                try {
                    template = new Template(name, reader, this.config, encoding);
                }
                catch (Template.WrongEncodingException wee) {
                    encoding = wee.specifiedEncoding;
                    reader = this.loader.getReader(source, encoding);
                    template = new Template(name, reader, this.config, encoding);
                }
                template.setLocale(locale);
            } else {
                StringWriter sw = new StringWriter();
                char[] buf = new char[4096];
                while (true) {
                    int charsRead;
                    if ((charsRead = reader.read(buf)) > 0) {
                        sw.write(buf, 0, charsRead);
                        continue;
                    }
                    if (charsRead == -1) break;
                }
                template = Template.getPlainTextTemplate(name, sw.toString(), this.config);
                template.setLocale(locale);
            }
            template.setEncoding(encoding);
        }
        finally {
            reader.close();
        }
        return template;
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        this.delay = delay;
    }

    public synchronized boolean getLocalizedLookup() {
        return this.localizedLookup;
    }

    public synchronized void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheStorage cacheStorage = this.storage;
        synchronized (cacheStorage) {
            this.storage.clear();
        }
    }

    private Object findTemplateSource(String name, Locale locale) throws IOException {
        if (this.localizedLookup) {
            int lastDot = name.lastIndexOf(46);
            String prefix = lastDot == -1 ? name : name.substring(0, lastDot);
            String suffix = lastDot == -1 ? "" : name.substring(lastDot);
            String localeName = LOCALE_SEPARATOR + locale.toString();
            StringBuffer buf = new StringBuffer(name.length() + localeName.length());
            buf.append(prefix);
            while (true) {
                buf.setLength(prefix.length());
                String path = buf.append(localeName).append(suffix).toString();
                Object templateSource = this.acquireTemplateSource(path);
                if (templateSource != null) {
                    return templateSource;
                }
                int lastUnderscore = localeName.lastIndexOf(95);
                if (lastUnderscore == -1) break;
                localeName = localeName.substring(0, lastUnderscore);
            }
            return null;
        }
        return this.acquireTemplateSource(name);
    }

    private Object acquireTemplateSource(String path) throws IOException {
        int asterisk = path.indexOf(42);
        if (asterisk == -1) {
            return this.loader.findTemplateSource(path);
        }
        StringTokenizer tok = new StringTokenizer(path, "/");
        int lastAsterisk = -1;
        ArrayList<String> tokpath = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String pathToken = tok.nextToken();
            if (pathToken.equals(ASTERISKSTR)) {
                if (lastAsterisk != -1) {
                    tokpath.remove(lastAsterisk);
                }
                lastAsterisk = tokpath.size();
            }
            tokpath.add(pathToken);
        }
        String basePath = this.concatPath(tokpath, 0, lastAsterisk);
        String resourcePath = this.concatPath(tokpath, lastAsterisk + 1, tokpath.size());
        StringBuffer buf = new StringBuffer(path.length()).append(basePath);
        int l = basePath.length();
        boolean debug = logger.isDebugEnabled();
        while (true) {
            Object templateSource;
            String fullPath = buf.append(resourcePath).toString();
            if (debug) {
                logger.debug("Trying to find template source " + fullPath);
            }
            if ((templateSource = this.loader.findTemplateSource(fullPath)) != null) {
                return templateSource;
            }
            if (l == 0) {
                return null;
            }
            l = basePath.lastIndexOf(47, l - 2) + 1;
            buf.setLength(l);
        }
    }

    private String concatPath(List path, int from, int to) {
        StringBuffer buf = new StringBuffer((to - from) * 16);
        for (int i = from; i < to; ++i) {
            buf.append(path.get(i)).append('/');
        }
        return buf.toString();
    }

    private static String normalizeName(String name) {
        if (name.indexOf("://") > 0) {
            return name;
        }
        while (true) {
            int parentDirPathLoc;
            if ((parentDirPathLoc = name.indexOf(PARENT_DIR_PATH)) == 0) {
                return null;
            }
            if (parentDirPathLoc == -1) {
                if (!name.startsWith(PARENT_DIR_PATH_PREFIX)) break;
                return null;
            }
            int previousSlashLoc = name.lastIndexOf(47, parentDirPathLoc - 1);
            name = name.substring(0, previousSlashLoc + 1) + name.substring(parentDirPathLoc + PARENT_DIR_PATH.length());
        }
        while (true) {
            int currentDirPathLoc;
            if ((currentDirPathLoc = name.indexOf(CURRENT_DIR_PATH)) == -1) {
                if (!name.startsWith(CURRENT_DIR_PATH_PREFIX)) break;
                name = name.substring(CURRENT_DIR_PATH_PREFIX.length());
                break;
            }
            name = name.substring(0, currentDirPathLoc) + name.substring(currentDirPathLoc + CURRENT_DIR_PATH.length() - 1);
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class CachedTemplate {
        Template template;
        Object source;
        long lastChecked;
        long lastModified;

        private CachedTemplate() {
        }
    }

    private static final class TemplateKey {
        private final String name;
        private final Locale locale;
        private final String encoding;
        private final boolean parse;

        TemplateKey(String name, Locale locale, String encoding, boolean parse) {
            this.name = name;
            this.locale = locale;
            this.encoding = encoding;
            this.parse = parse;
        }

        public boolean equals(Object o) {
            if (o instanceof TemplateKey) {
                TemplateKey tk = (TemplateKey)o;
                return this.parse == tk.parse && this.name.equals(tk.name) && this.locale.equals(tk.locale) && this.encoding.equals(tk.encoding);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.locale.hashCode() ^ this.encoding.hashCode() ^ (this.parse ? Boolean.FALSE : Boolean.TRUE).hashCode();
        }
    }
}

