/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo.handler;

import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.jzonic.jlo.ErrorHandler;
import org.jzonic.jlo.LogRecord;
import org.jzonic.jlo.handler.AbstractHandler;

public class RollingDateFileHandler
extends AbstractHandler {
    private String fileName = null;
    private int maxSize = 0;
    private String dateFormat = "dd.MM.yyyy";

    public RollingDateFileHandler(String configName) {
        super(configName);
    }

    public void publish(String msg) {
        if (this.fileName == null) {
            ErrorHandler.reportError("No filename specified");
        }
        try {
            FileWriter fw = new FileWriter(this.prepareFileName(), true);
            fw.write(msg + "\n");
            fw.close();
        }
        catch (Exception e) {
            ErrorHandler.reportError("Exception while trying to write to file: " + this.fileName, e);
        }
    }

    public void publish(LogRecord lr) {
        this.publish(lr.getMessage());
    }

    public void setParameter(Hashtable parameters) {
        if (parameters.containsKey("file")) {
            this.fileName = (String)parameters.get("file");
        }
        if (parameters.containsKey("maxsize")) {
            this.maxSize = Integer.parseInt((String)parameters.get("maxsize"));
        }
        if (parameters.containsKey("format")) {
            this.dateFormat = (String)parameters.get("format");
        }
    }

    private String prepareFileName() {
        if (this.fileName != null) {
            String tmpName = this.fileName.toLowerCase();
            int pos = tmpName.indexOf("${date}");
            if (pos == -1) {
                return this.fileName;
            }
            Date rightNow = new Date(System.currentTimeMillis());
            String firstPart = this.fileName.substring(0, pos - 1);
            String secondPart = this.fileName.substring(pos + 7);
            SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
            String dateString = formatter.format(rightNow);
            return firstPart + dateString + secondPart;
        }
        return null;
    }
}

