/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.jzonic.jlo.Channel;
import org.jzonic.jlo.LogGenerator;
import org.jzonic.jlo.LogManager;
import org.jzonic.jlo.LogRecord;
import org.jzonic.jlo.Target;
import org.jzonic.jlo.formatter.CallerStack;
import org.jzonic.jlo.processor.LogProcessor;
import org.jzonic.jlo.processor.LogProcessorFactory;

public class Logger
implements Log {
    private static final LogProcessor processor = LogProcessorFactory.getLogProcessor();
    private Vector generators;
    private int targets;
    private String sourceClass = null;
    private String sourceMethod = null;
    private String name;

    private Logger() {
    }

    public Logger(String name, int targets) {
        this.name = name;
        this.targets = targets;
        this.generators = new Vector();
    }

    public void addLogGenerator(LogGenerator lg) {
        this.generators.add(lg);
    }

    public Vector getLogGenerators() {
        return this.generators;
    }

    public void log(Target curtarget, String msg, Throwable thrown) {
        if ((curtarget.intValue() & this.targets) == curtarget.intValue()) {
            LogRecord lr = new LogRecord(msg, curtarget);
            lr.setLoggerName(this.name);
            String cn = CallerStack.getCallerClass(this.getClass()).getName();
            lr.setSourceClassName(cn);
            lr.setTarget(curtarget);
            lr.setThrown(thrown);
            this.log(lr);
        }
    }

    public void log(Target target, String msg) {
        this.log(target, msg, null);
    }

    public void log(LogRecord record) {
        int i = 0;
        while (i < this.generators.size()) {
            LogGenerator lg = (LogGenerator)this.generators.get(i);
            processor.processEvent(lg, record);
            ++i;
        }
        if (LogManager.isChannelOn(record.getTarget().getName())) {
            Channel myChannel = LogManager.getChannel(record.getTarget().getName());
            record.setTarget(record.getTarget());
            myChannel.log(record);
        }
    }

    public void setTargets(int targets) {
        this.targets = targets;
    }

    public boolean isLoggable(Target target) {
        return (target.intValue() & this.targets) == target.intValue();
    }

    public int getTargets() {
        return this.targets;
    }

    public void setLoggerName(String name) {
        this.name = name;
    }

    public String getLoggerName() {
        return this.name;
    }

    public void trace(Object obj) {
        if (obj != null) {
            this.log(Target.trace, obj.toString(), null);
        }
    }

    public void trace(Object obj, Throwable throwable) {
        if (obj != null) {
            this.log(Target.trace, obj.toString(), throwable);
        }
    }

    public void info(Object obj) {
        if (obj != null) {
            this.log(Target.info, obj.toString(), null);
        }
    }

    public void info(Object obj, Throwable throwable) {
        if (obj != null) {
            this.log(Target.info, obj.toString(), throwable);
        }
    }

    public void debug(Object obj) {
        if (obj != null) {
            this.log(Target.debug, obj.toString(), null);
        }
    }

    public void debug(Object obj, Throwable throwable) {
        if (obj != null) {
            this.log(Target.debug, obj.toString(), throwable);
        }
    }

    public void warn(Object obj) {
        if (obj != null) {
            this.log(Target.warn, obj.toString(), null);
        }
    }

    public void warn(Object obj, Throwable throwable) {
        if (obj != null) {
            this.log(Target.warn, obj.toString(), throwable);
        }
    }

    public void error(Object obj) {
        if (obj != null) {
            this.log(Target.error, obj.toString(), null);
        }
    }

    public void error(Object obj, Throwable throwable) {
        if (obj != null) {
            this.log(Target.error, obj.toString(), throwable);
        }
    }

    public void fatal(Object obj) {
        if (obj != null) {
            this.log(Target.fatal, obj.toString(), null);
        }
    }

    public void fatal(Object obj, Throwable throwable) {
        if (obj != null) {
            this.log(Target.fatal, obj.toString(), throwable);
        }
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(Target.trace);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(Target.info);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Target.debug);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(Target.warn);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(Target.error);
    }

    public boolean isFatalEnabled() {
        return this.isLoggable(Target.fatal);
    }
}

