/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

final class MysqlDefs {
    static final int SLEEP = 0;
    static final int QUIT = 1;
    static final int INIT_DB = 2;
    static final int QUERY = 3;
    static final int FIELD_LIST = 4;
    static final int CREATE_DB = 5;
    static final int DROP_DB = 6;
    static final int RELOAD = 7;
    static final int SHUTDOWN = 8;
    static final int STATISTICS = 9;
    static final int PROCESS_INFO = 10;
    static final int CONNECT = 11;
    static final int PROCESS_KILL = 12;
    static final int DEBUG = 13;
    static final int PING = 14;
    static final int TIME = 15;
    static final int DELAYED_INSERT = 16;
    static final int CHANGE_USER = 17;
    static final int COM_BINLOG_DUMP = 18;
    static final int COM_TABLE_DUMP = 19;
    static final int COM_CONNECT_OUT = 20;
    static final int COM_REGISTER_SLAVE = 21;
    static final int COM_PREPARE = 22;
    static final int COM_EXECUTE = 23;
    static final int COM_LONG_DATA = 24;
    static final int FIELD_TYPE_DECIMAL = 0;
    static final int FIELD_TYPE_TINY = 1;
    static final int FIELD_TYPE_SHORT = 2;
    static final int FIELD_TYPE_LONG = 3;
    static final int FIELD_TYPE_FLOAT = 4;
    static final int FIELD_TYPE_DOUBLE = 5;
    static final int FIELD_TYPE_NULL = 6;
    static final int FIELD_TYPE_TIMESTAMP = 7;
    static final int FIELD_TYPE_LONGLONG = 8;
    static final int FIELD_TYPE_INT24 = 9;
    static final int FIELD_TYPE_DATE = 10;
    static final int FIELD_TYPE_TIME = 11;
    static final int FIELD_TYPE_DATETIME = 12;
    static final int FIELD_TYPE_YEAR = 13;
    static final int FIELD_TYPE_NEWDATE = 14;
    static final int FIELD_TYPE_VARCHAR = 15;
    static final int FIELD_TYPE_ENUM = 247;
    static final int FIELD_TYPE_SET = 248;
    static final int FIELD_TYPE_TINY_BLOB = 249;
    static final int FIELD_TYPE_MEDIUM_BLOB = 250;
    static final int FIELD_TYPE_LONG_BLOB = 251;
    static final int FIELD_TYPE_BLOB = 252;
    static final int FIELD_TYPE_VAR_STRING = 253;
    static final int FIELD_TYPE_STRING = 254;
    static final int ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    static final int MAX_ROWS = 50000000;
    static final String MIN_DOUBLE_VAL_STRING = "-1.7976931348623157E+308";
    static final String MAX_DOUBLE_VAL_STRING = "1.7976931348623157E+308";
    static final String MIN_FLOAT_VAL_STRING = "-3.402823466E+38";
    static final String MAX_FLOAT_VAL_STRING = "3.402823466E+38";
    static final String NAN_VAL_STRING = "0";
    static final int COM_CHANGE_USER = 17;
    static final long LENGTH_TINYBLOB = 255L;
    static final long LENGTH_BLOB = 65535L;
    static final long LENGTH_MEDIUMBLOB = 0xFFFFFFL;
    static final long LENGTH_LONGBLOB = 0xFFFFFFFFL;
    public static final int NO_CHARSET_INFO = -1;

    MysqlDefs() {
    }

    static int mysqlToJavaType(int mysqlType) {
        int jdbcType;
        switch (mysqlType) {
            case 0: {
                jdbcType = 3;
                break;
            }
            case 1: {
                jdbcType = -6;
                break;
            }
            case 2: {
                jdbcType = 5;
                break;
            }
            case 3: {
                jdbcType = 4;
                break;
            }
            case 4: {
                jdbcType = 7;
                break;
            }
            case 5: {
                jdbcType = 8;
                break;
            }
            case 6: {
                jdbcType = 0;
                break;
            }
            case 7: {
                jdbcType = 93;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: {
                jdbcType = 4;
                break;
            }
            case 10: {
                jdbcType = 91;
                break;
            }
            case 11: {
                jdbcType = 92;
                break;
            }
            case 12: {
                jdbcType = 93;
                break;
            }
            case 13: {
                jdbcType = 91;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 247: {
                jdbcType = 1;
                break;
            }
            case 248: {
                jdbcType = 1;
                break;
            }
            case 249: {
                jdbcType = -3;
                break;
            }
            case 250: {
                jdbcType = -4;
                break;
            }
            case 251: {
                jdbcType = -4;
                break;
            }
            case 252: {
                jdbcType = -4;
                break;
            }
            case 15: 
            case 253: {
                jdbcType = 12;
                break;
            }
            case 254: {
                jdbcType = 1;
                break;
            }
            default: {
                jdbcType = 12;
            }
        }
        return jdbcType;
    }

    static int mysqlToJavaType(String mysqlType) {
        if (mysqlType.equalsIgnoreCase("TINYINT")) {
            return MysqlDefs.mysqlToJavaType(1);
        }
        if (mysqlType.equalsIgnoreCase("SMALLINT")) {
            return MysqlDefs.mysqlToJavaType(2);
        }
        if (mysqlType.equalsIgnoreCase("MEDIUMINT")) {
            return MysqlDefs.mysqlToJavaType(9);
        }
        if (mysqlType.equalsIgnoreCase("INT") || mysqlType.equalsIgnoreCase("INTEGER")) {
            return MysqlDefs.mysqlToJavaType(3);
        }
        if (mysqlType.equalsIgnoreCase("BIGINT")) {
            return MysqlDefs.mysqlToJavaType(8);
        }
        if (mysqlType.equalsIgnoreCase("INT24")) {
            return MysqlDefs.mysqlToJavaType(9);
        }
        if (mysqlType.equalsIgnoreCase("REAL")) {
            return MysqlDefs.mysqlToJavaType(5);
        }
        if (mysqlType.equalsIgnoreCase("FLOAT")) {
            return MysqlDefs.mysqlToJavaType(4);
        }
        if (mysqlType.equalsIgnoreCase("DECIMAL")) {
            return MysqlDefs.mysqlToJavaType(0);
        }
        if (mysqlType.equalsIgnoreCase("NUMERIC")) {
            return MysqlDefs.mysqlToJavaType(0);
        }
        if (mysqlType.equalsIgnoreCase("DOUBLE")) {
            return MysqlDefs.mysqlToJavaType(5);
        }
        if (mysqlType.equalsIgnoreCase("CHAR")) {
            return MysqlDefs.mysqlToJavaType(254);
        }
        if (mysqlType.equalsIgnoreCase("VARCHAR")) {
            return MysqlDefs.mysqlToJavaType(253);
        }
        if (mysqlType.equalsIgnoreCase("DATE")) {
            return MysqlDefs.mysqlToJavaType(10);
        }
        if (mysqlType.equalsIgnoreCase("TIME")) {
            return MysqlDefs.mysqlToJavaType(11);
        }
        if (mysqlType.equalsIgnoreCase("YEAR")) {
            return MysqlDefs.mysqlToJavaType(13);
        }
        if (mysqlType.equalsIgnoreCase("TIMESTAMP")) {
            return MysqlDefs.mysqlToJavaType(7);
        }
        if (mysqlType.equalsIgnoreCase("DATETIME")) {
            return MysqlDefs.mysqlToJavaType(12);
        }
        if (mysqlType.equalsIgnoreCase("TINYBLOB")) {
            return -2;
        }
        if (mysqlType.equalsIgnoreCase("BLOB")) {
            return -4;
        }
        if (mysqlType.equalsIgnoreCase("MEDIUMBLOB")) {
            return -4;
        }
        if (mysqlType.equalsIgnoreCase("LONGBLOB")) {
            return -4;
        }
        if (mysqlType.equalsIgnoreCase("TINYTEXT")) {
            return 12;
        }
        if (mysqlType.equalsIgnoreCase("TEXT")) {
            return -1;
        }
        if (mysqlType.equalsIgnoreCase("MEDIUMTEXT")) {
            return -1;
        }
        if (mysqlType.equalsIgnoreCase("LONGTEXT")) {
            return -1;
        }
        if (mysqlType.equalsIgnoreCase("ENUM")) {
            return MysqlDefs.mysqlToJavaType(247);
        }
        if (mysqlType.equalsIgnoreCase("SET")) {
            return MysqlDefs.mysqlToJavaType(248);
        }
        return 1111;
    }
}

