/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class ConvertURL {
    static String convertURL(String href) {
        StringBuffer output = new StringBuffer();
        if (!(href.startsWith("http") || href.startsWith("javascript:") || href.startsWith("mailto:") || href.startsWith("aim:") || href.startsWith("<%=response.encodeURL"))) {
            href = href.replaceAll("<%=", "\" + ");
            href = href.replaceAll("%>", " + \"");
            boolean redundantEnd = false;
            if (href.endsWith(" + \"")) {
                redundantEnd = true;
                href = href.substring(0, href.length() - 4);
            }
            boolean redundantBegin = false;
            if (href.startsWith("\" + ")) {
                redundantBegin = true;
                href = href.substring(4);
            }
            if (redundantBegin) {
                output.append("<%=response.encodeURL(");
            } else {
                output.append("<%=response.encodeURL(\"");
            }
            output.append(href);
            if (redundantEnd) {
                output.append(")%>");
            } else {
                output.append("\")%>");
            }
        } else {
            return href;
        }
        return output.toString();
    }

    static String convertTagA(String tagA) throws IllegalArgumentException {
        int firstIndex;
        String output = "";
        if (!tagA.startsWith("<a ")) {
            throw new IllegalArgumentException();
        }
        if (!tagA.endsWith(">")) {
            throw new IllegalArgumentException();
        }
        if (tagA.indexOf(62) != tagA.lastIndexOf(62)) {
            // empty if block
        }
        if ((firstIndex = tagA.indexOf("href=\"")) == -1) {
            System.out.println("WARNING: TagA does not have href: " + tagA);
            return tagA;
        }
        int lastIndex = tagA.indexOf("\"", firstIndex + 6);
        String begin = tagA.substring(0, firstIndex + 6);
        String href = tagA.substring(firstIndex + 6, lastIndex);
        String end = tagA.substring(lastIndex);
        output = begin + ConvertURL.convertURL(href) + end;
        return output;
    }

    static String convertTagForm(String tagForm) throws IllegalArgumentException {
        int firstIndex;
        String output = "";
        if (!tagForm.startsWith("<form ")) {
            throw new IllegalArgumentException();
        }
        if (!tagForm.endsWith(">")) {
            throw new IllegalArgumentException();
        }
        if (tagForm.indexOf(62) != tagForm.lastIndexOf(62)) {
            // empty if block
        }
        if ((firstIndex = tagForm.indexOf("action=\"")) == -1) {
            System.out.println("WARNING: TagForm does not have action: " + tagForm);
            return tagForm;
        }
        int lastIndex = tagForm.indexOf("\"", firstIndex + 8);
        String begin = tagForm.substring(0, firstIndex + 8);
        String href = tagForm.substring(firstIndex + 8, lastIndex);
        String end = tagForm.substring(lastIndex);
        output = begin + ConvertURL.convertURL(href) + end;
        return output;
    }

    static String convertTagMeta(String tagMeta) throws IllegalArgumentException {
        int firstIndex;
        String output = "";
        if (!tagMeta.startsWith("<meta ")) {
            throw new IllegalArgumentException();
        }
        if (!tagMeta.endsWith(">")) {
            throw new IllegalArgumentException();
        }
        if (tagMeta.indexOf(62) != tagMeta.lastIndexOf(62)) {
            // empty if block
        }
        if ((firstIndex = tagMeta.indexOf("url=")) == -1) {
            System.out.println("WARNING: TagMeta does not have url=: " + tagMeta);
            return tagMeta;
        }
        int lastIndex = tagMeta.indexOf("'", firstIndex + 4);
        String begin = tagMeta.substring(0, firstIndex + 4);
        String href = tagMeta.substring(firstIndex + 4, lastIndex);
        String end = tagMeta.substring(lastIndex);
        output = begin + ConvertURL.convertURL(href) + end;
        return output;
    }

    static String convertLine(String line, String startToken, String endToken) throws IllegalArgumentException {
        int startIndex = -1;
        int endIndex = -1;
        while ((startIndex = line.indexOf(startToken, endIndex + 1)) >= 0 && startIndex + 1 < line.length()) {
            char charBefore;
            int beginSearchEndIndex = startIndex + 1;
            while ((endIndex = line.indexOf(endToken, beginSearchEndIndex)) >= 0 && (charBefore = line.charAt(endIndex - 1)) == '%') {
                beginSearchEndIndex = endIndex + 1;
            }
            if (endIndex < 0) break;
            String matches = line.substring(startIndex, endIndex + 1);
            for (int k = 0; k < matches.length(); ++k) {
            }
            String replace = null;
            if (startToken.equals("<a ")) {
                replace = ConvertURL.convertTagA(matches);
            } else if (startToken.equals("<form ")) {
                replace = ConvertURL.convertTagForm(matches);
            } else if (startToken.equals("<meta ")) {
                replace = ConvertURL.convertTagMeta(matches);
            } else {
                throw new IllegalArgumentException();
            }
            if (replace == null) {
                replace = matches;
            }
            line = line.substring(0, startIndex) + replace + line.substring(endIndex + 1);
            endIndex = startIndex + replace.length() - 1;
            if (endIndex + 1 < line.length()) continue;
            break;
        }
        return line;
    }

    static String convertLine(String line) throws Exception {
        try {
            String linewithA = ConvertURL.convertLine(line, "<a ", ">");
            String linewithAandForm = ConvertURL.convertLine(linewithA, "<form ", ">");
            String linewithAandFormAndMeta = ConvertURL.convertLine(linewithAandForm, "<meta ", ">");
            return linewithAandFormAndMeta;
        }
        catch (Exception ex) {
            System.out.println("line = " + line);
            throw ex;
        }
    }

    public static ArrayList getContent(String fileName) {
        ArrayList<String> arrLine = new ArrayList<String>();
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String inLine = reader.readLine();
            while (inLine != null) {
                arrLine.add(inLine + "\n");
                inLine = reader.readLine();
            }
            reader.close();
            return arrLine;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void convertFile(String srcFilename, String descFilename) throws Exception {
        ArrayList<String> descArr = new ArrayList<String>();
        ArrayList tempArr = ConvertURL.getContent(srcFilename);
        Iterator iterator = tempArr.iterator();
        while (iterator.hasNext()) {
            descArr.add(ConvertURL.convertLine((String)iterator.next()));
        }
        ConvertURL.ExportContentToFile(descArr, descFilename);
    }

    public static void ExportContentToFile(ArrayList lines, String fileName) {
        String curDir = System.getProperty("user.dir");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(curDir + "/out/" + fileName));
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                out.write((String)iterator.next());
            }
            out.close();
        }
        catch (IOException e) {
            System.out.print(e);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args[0].equals("all")) {
                String curDir = System.getProperty("user.dir");
                File dir = new File(curDir);
                if (dir.isFile()) {
                    throw new IOException("IOException -> BadInputException: not a directory.");
                }
                File[] files = dir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isFile()) {
                            String absPath = file.getAbsolutePath();
                            if (!absPath.endsWith(".jsp")) continue;
                            int lastIndex = absPath.lastIndexOf(92);
                            String name = absPath.substring(lastIndex + 1);
                            System.out.println("name = " + name);
                            ConvertURL.convertFile(name, name);
                            continue;
                        }
                        System.out.println("get folder = " + file);
                    }
                }
                dir.delete();
            } else {
                ConvertURL.convertFile(args[0], args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

