/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo.processor;

import java.io.InputStream;
import java.util.Properties;
import org.jzonic.jlo.processor.AsynchronousLogProcessor;
import org.jzonic.jlo.processor.DirectLogProcessor;
import org.jzonic.jlo.processor.LogProcessor;

public class LogProcessorFactory {
    private static LogProcessor lp = null;
    private static LogProcessorFactory lpf = null;

    private LogProcessorFactory() {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream fis = cl.getResourceAsStream("jlo.properties");
            if (fis == null) {
                lp = new AsynchronousLogProcessor();
            } else {
                Properties properties = new Properties();
                properties.load(fis);
                String ptype = properties.getProperty("processor");
                lp = ptype != null ? (ptype.equalsIgnoreCase("direct") ? new DirectLogProcessor() : new AsynchronousLogProcessor()) : new AsynchronousLogProcessor();
            }
        }
        catch (Exception e) {
            lp = new AsynchronousLogProcessor();
        }
    }

    public static LogProcessor getLogProcessor() {
        if (lpf == null) {
            lpf = new LogProcessorFactory();
            System.out.println("Using " + lp.getProcessorName() + " as log processor");
        }
        return lp;
    }
}

