/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.image.utils;

import com.octo.captcha.engine.image.ImageCaptchaEngine;
import com.octo.captcha.engine.image.fisheye.SimpleFishEyeEngine;
import com.octo.captcha.engine.image.gimpy.BaffleListGimpyEngine;
import com.octo.captcha.engine.image.gimpy.BasicListGimpyEngine;
import com.octo.captcha.engine.image.gimpy.DefaultGimpyEngine;
import com.octo.captcha.engine.image.gimpy.DeformedBaffleListGimpyEngine;
import com.octo.captcha.engine.image.gimpy.DoubleRandomListGimpyEngine;
import com.octo.captcha.engine.image.gimpy.SimpleListImageCaptchaEngine;
import com.octo.captcha.engine.image.utils.ImageToFile;
import com.octo.captcha.image.ImageCaptcha;
import java.io.File;
import java.io.IOException;

public class ImageCaptchaToJPEG {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage : engineClassName outputDir iterations");
            System.exit(1);
        }
        System.out.println("engine initialized");
        int iterations = Integer.parseInt(args[2]);
        String outfile = args[1];
        System.out.println("args : image captcha engine class='" + args[0] + "', " + "output dir='" + args[1] + "'" + ",iterations='" + args[2] + "'");
        if (args[0].equals("all")) {
            ImageCaptchaToJPEG.generate(iterations, new BasicListGimpyEngine(), outfile);
            ImageCaptchaToJPEG.generate(iterations, new BaffleListGimpyEngine(), outfile);
            ImageCaptchaToJPEG.generate(iterations, new DefaultGimpyEngine(), outfile);
            ImageCaptchaToJPEG.generate(iterations, new DeformedBaffleListGimpyEngine(), outfile);
            ImageCaptchaToJPEG.generate(iterations, new DoubleRandomListGimpyEngine(), outfile);
            ImageCaptchaToJPEG.generate(iterations, new SimpleListImageCaptchaEngine(), outfile);
            ImageCaptchaToJPEG.generate(iterations, new SimpleFishEyeEngine(), outfile);
        } else {
            ImageCaptchaEngine pixCapchaEngine = (ImageCaptchaEngine)Class.forName(args[0]).newInstance();
            System.out.println("Beginning generation");
            ImageCaptchaToJPEG.generate(iterations, pixCapchaEngine, outfile);
        }
        System.exit(0);
    }

    private static void generate(int iterations, ImageCaptchaEngine pixCapchaEngine, String outfile) throws IOException {
        int i = 0;
        while (i < iterations) {
            ImageCaptcha captcha = pixCapchaEngine.getNextImageCaptcha();
            System.out.println("Captcha " + i + " retrieved");
            File dirout = new File(outfile);
            dirout.mkdirs();
            File out = new File(dirout, File.separator + pixCapchaEngine.getClass().getName().substring(pixCapchaEngine.getClass().getPackage().getName().length() + 1) + "Captcha_" + i + ".jpg");
            ImageToFile.serialize(captcha.getImageChallenge(), out);
            System.out.println("File i created " + out.toURL());
            ++i;
        }
    }
}

