/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.image.fisheye;

import com.jhlabs.image.RippleFilter;
import com.jhlabs.image.SphereFilter;
import com.jhlabs.image.TwirlFilter;
import com.jhlabs.image.WaterFilter;
import com.octo.captcha.component.image.backgroundgenerator.FileReaderRandomBackgroundGenerator;
import com.octo.captcha.component.image.deformation.ImageDeformationByFilters;
import com.octo.captcha.engine.image.ListImageCaptchaEngine;
import com.octo.captcha.image.fisheye.FishEyeFactory;
import java.awt.image.ImageFilter;

public class SimpleFishEyeEngine
extends ListImageCaptchaEngine {
    protected void buildInitialFactories() {
        SphereFilter sphere = new SphereFilter();
        RippleFilter ripple = new RippleFilter();
        TwirlFilter twirl = new TwirlFilter();
        WaterFilter water = new WaterFilter();
        ripple.setWaveType(3);
        ripple.setXAmplitude(10.0);
        ripple.setYAmplitude(10.0);
        ripple.setXWavelength(10.0);
        ripple.setYWavelength(10.0);
        ripple.setEdgeAction(1);
        water.setAmplitude(10.0);
        water.setAntialias(true);
        water.setWavelength(20.0);
        twirl.setAngle(4.0);
        sphere.setRefractionIndex(2.0);
        ImageDeformationByFilters rippleDef = new ImageDeformationByFilters(new ImageFilter[]{ripple});
        ImageDeformationByFilters sphereDef = new ImageDeformationByFilters(new ImageFilter[]{sphere});
        ImageDeformationByFilters waterDef = new ImageDeformationByFilters(new ImageFilter[]{water});
        ImageDeformationByFilters twirlDef = new ImageDeformationByFilters(new ImageFilter[]{twirl});
        FileReaderRandomBackgroundGenerator generator = new FileReaderRandomBackgroundGenerator(new Integer(250), new Integer(250), "./fisheyebackgrounds");
        this.addFactory(new FishEyeFactory(generator, sphereDef, new Integer(30), new Integer(11)));
        this.addFactory(new FishEyeFactory(generator, rippleDef, new Integer(30), new Integer(11)));
        this.addFactory(new FishEyeFactory(generator, waterDef, new Integer(30), new Integer(11)));
        this.addFactory(new FishEyeFactory(generator, twirlDef, new Integer(30), new Integer(11)));
    }
}

