/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.textpaster;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.textpaster.AbstractTextPaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class RandomTextPaster
extends AbstractTextPaster {
    public RandomTextPaster(Integer minAcceptedWordLenght, Integer maxAcceptedWordLenght, Color textColor) {
        super(minAcceptedWordLenght, maxAcceptedWordLenght, textColor);
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) {
        BufferedImage out = this.copyBackground(background);
        Graphics2D pie = this.pasteBackgroundAndSetTextColor(out, background);
        Font maxFont = this.getMaxFont(attributedWord.getIterator());
        Rectangle2D bounds = this.getTextBoundaries(pie, maxFont, attributedWord);
        int[] randomDeviation = this.getRandomDeviation(background, bounds, maxFont);
        pie.drawString(attributedWord.getIterator(), randomDeviation[0], randomDeviation[1]);
        pie.dispose();
        return out;
    }

    int[] getRandomDeviation(BufferedImage background, Rectangle2D bounds, Font maxFont) {
        int[] randomDeviation = new int[2];
        Double maxx = new Double((double)background.getWidth() - bounds.getWidth());
        Double maxy = new Double((double)background.getHeight() - bounds.getHeight());
        if (maxx.intValue() < 0 || maxy.intValue() < 0) {
            throw new CaptchaException("word is too big, try to use less letters, smaller font or bigger background");
        }
        randomDeviation[0] = this.myRandom.nextInt(maxx.intValue());
        randomDeviation[1] = maxFont.getSize() + this.myRandom.nextInt(Math.max(maxy.intValue() - maxFont.getSize(), 1));
        return randomDeviation;
    }

    Rectangle2D getTextBoundaries(Graphics2D pie, Font maxFont, AttributedString attributedWord) {
        pie.setFont(maxFont);
        FontRenderContext frc = pie.getFontRenderContext();
        Rectangle2D bounds = pie.getFont().getStringBounds(attributedWord.getIterator(), attributedWord.getIterator().getBeginIndex(), attributedWord.getIterator().getEndIndex(), frc);
        return bounds;
    }

    Font getMaxFont(AttributedCharacterIterator it) {
        Font max = new Font("serif", 10, 2);
        int i = it.getBeginIndex();
        while (i < it.getEndIndex()) {
            it.setIndex(i);
            Font font = (Font)it.getAttribute(TextAttribute.FONT);
            if (font != null && font.getSize() >= max.getSize()) {
                max = font;
            }
            ++i;
        }
        return max;
    }
}

