/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.textpaster;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.textpaster.RandomTextPaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public class DoubleRandomTextPaster
extends RandomTextPaster {
    public DoubleRandomTextPaster(Integer minAcceptedWordLenght, Integer maxAcceptedWordLenght, Color textColor) {
        super(minAcceptedWordLenght, maxAcceptedWordLenght, textColor);
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) throws CaptchaException {
        BufferedImage out = this.copyBackground(background);
        Graphics2D pie = this.pasteBackgroundAndSetTextColor(out, background);
        Font maxFont = this.getMaxFont(attributedWord.getIterator());
        Rectangle2D bounds = this.getTextBoundaries(pie, maxFont, attributedWord);
        Double maxx = new Double((double)background.getWidth() - bounds.getWidth());
        Double maxy = new Double((double)background.getHeight() - bounds.getHeight() - 0.4 * (double)maxFont.getSize());
        if (maxx.intValue() < 0 || maxy.intValue() < 0) {
            throw new CaptchaException("word is too big, try to use less letters,smaller font or bigger background");
        }
        int xdev = new Double((1.0 + this.myRandom.nextDouble()) * 0.25 * (double)maxFont.getSize()).intValue();
        int ydev = new Double((1.0 + this.myRandom.nextDouble()) * 0.2 * (double)maxFont.getSize()).intValue();
        int x = this.myRandom.nextInt(maxx.intValue() - xdev);
        int y = maxFont.getSize() + this.myRandom.nextInt(maxy.intValue() - ydev);
        pie.drawString(attributedWord.getIterator(), x, y);
        pie.drawString(attributedWord.getIterator(), x + xdev, y + ydev);
        pie.dispose();
        return out;
    }
}

