/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.textpaster;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.textpaster.RandomTextPaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public class BaffleRandomTextPaster
extends RandomTextPaster {
    private Integer numberOfHolesPerGlyph = new Integer(3);
    private Color holesColor;

    public BaffleRandomTextPaster(Integer minAcceptedWordLenght, Integer maxAcceptedWordLenght, Color textColor, Integer numberOfHolesPerGlyph, Color holesColor) {
        super(minAcceptedWordLenght, maxAcceptedWordLenght, textColor);
        this.numberOfHolesPerGlyph = numberOfHolesPerGlyph != null ? numberOfHolesPerGlyph : this.numberOfHolesPerGlyph;
        this.holesColor = holesColor != null ? holesColor : textColor;
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) throws CaptchaException {
        BufferedImage out = this.copyBackground(background);
        Graphics2D pie = this.pasteBackgroundAndSetTextColor(out, background);
        Font maxFont = this.getMaxFont(attributedWord.getIterator());
        Rectangle2D bounds = this.getTextBoundaries(pie, maxFont, attributedWord);
        int[] randomDeviation = this.getRandomDeviation(background, bounds, maxFont);
        pie.drawString(attributedWord.getIterator(), randomDeviation[0], randomDeviation[1]);
        pie.setColor(this.holesColor);
        int numberOfHoles = this.numberOfHolesPerGlyph * attributedWord.getIterator().getEndIndex();
        int circleMaxSize = maxFont.getSize() / 3;
        if (circleMaxSize == 0) {
            throw new CaptchaException("The font is too small");
        }
        int i = 0;
        while (i < numberOfHoles) {
            int circleSize = this.myRandom.nextInt(circleMaxSize) / 2 + circleMaxSize / 2;
            double circlex = bounds.getMaxX() * this.myRandom.nextGaussian();
            double circley = bounds.getMaxY() * this.myRandom.nextGaussian();
            Ellipse2D.Double circle = new Ellipse2D.Double((double)randomDeviation[0] + circlex, (double)(randomDeviation[1] - maxFont.getSize() / 2) + circley, circleSize, circleSize);
            pie.fill(circle);
            ++i;
        }
        pie.dispose();
        return out;
    }
}

