/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.deformation;

import com.octo.captcha.component.image.deformation.ImageDeformation;
import com.octo.captcha.component.image.utils.ToolkitFactory;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;

public class ImageDeformationByFilters
implements ImageDeformation {
    private ImageFilter[] filters;

    public ImageDeformationByFilters(ImageFilter[] filters) {
        this.filters = filters;
    }

    public BufferedImage deformImage(BufferedImage image) {
        if (this.filters != null) {
            BufferedImage clone = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            clone.getGraphics().drawImage(image, 0, 0, null, null);
            int i = 0;
            while (i < this.filters.length) {
                ImageFilter filter = this.filters[i];
                FilteredImageSource filtered = new FilteredImageSource(clone.getSource(), filter);
                Image temp = ToolkitFactory.getToolkit().createImage(filtered);
                clone.getGraphics().drawImage(temp, 0, 0, Color.white, null);
                ++i;
            }
            clone.getGraphics().dispose();
            return clone;
        }
        return image;
    }
}

