/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo.handler;

import java.io.FileWriter;
import java.util.Hashtable;
import org.jzonic.jlo.ErrorHandler;
import org.jzonic.jlo.LogRecord;
import org.jzonic.jlo.VariableManager;
import org.jzonic.jlo.handler.AbstractHandler;

public class FileHandler
extends AbstractHandler {
    private static final VariableManager vm = VariableManager.getInstance();
    private String fileName = null;
    private int maxSize = 0;

    public FileHandler(String configName) {
        super(configName);
    }

    public void publish(String msg) {
        if (this.fileName == null) {
            ErrorHandler.reportError("No filename specified");
        }
        try {
            FileWriter fw = new FileWriter(this.fileName, true);
            fw.write(msg + "\n");
            fw.close();
        }
        catch (Exception e) {
            ErrorHandler.reportError("Exception while trying to write to file: " + this.fileName, e);
        }
    }

    public void publish(LogRecord lr) {
        this.publish(lr.getMessage());
    }

    public void setParameter(Hashtable parameters) {
        if (parameters.containsKey("file")) {
            this.fileName = (String)parameters.get("file");
            this.fileName = vm.replaceVariables(this.fileName, this.getConfigurationName());
        }
        if (parameters.containsKey("maxsize")) {
            this.maxSize = Integer.parseInt((String)parameters.get("maxsize"));
        }
    }
}

