/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jzonic.jlo.events.FileListener;
import org.jzonic.jlo.events.FileListenerEvent;

public class FileWatcher
extends Thread {
    private HashMap fileMap = new HashMap();
    private List fileListenerList = new Vector();
    private volatile Thread watcher;
    private int interval = 6000;

    public void addFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            long lastModified = file.lastModified();
            this.fileMap.put(fileName, new Long(lastModified));
        }
    }

    public void addFileListener(FileListener fileListener, String configurationName) {
        this.fileListenerList.add(fileListener);
    }

    public void setInterval(int seconds) {
        this.interval = seconds * 1000;
    }

    public void stopWatching() {
        this.watcher = null;
    }

    public void start() {
        this.watcher = new Thread(this);
        this.watcher.setDaemon(true);
        this.watcher.start();
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (thisThread == this.watcher) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                this.watcher = null;
            }
            Iterator it = this.fileMap.keySet().iterator();
            while (it.hasNext()) {
                String fileName = (String)it.next();
                long lastModified = (Long)this.fileMap.get(fileName);
                lastModified = this.checkFile(fileName, lastModified);
                this.fileMap.put(fileName, new Long(lastModified));
            }
        }
    }

    public FileListener[] getFileListeners() {
        return (FileListener[])this.fileListenerList.toArray();
    }

    private long checkFile(String fileName, long lm) {
        File newFile = new File(fileName);
        if (newFile.lastModified() > lm) {
            lm = newFile.lastModified();
            Iterator iterator = this.fileListenerList.iterator();
            while (iterator.hasNext()) {
                FileListener listener = (FileListener)iterator.next();
                listener.fileChanged(new FileListenerEvent(newFile, null));
            }
        }
        return lm;
    }
}

