/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class LocalizingKeyFinder
extends MatchingTask {
    private String bundle;
    private String startToken;
    private String endToken;
    private String bundleEncoding;
    private Vector filesets = new Vector();
    private Hashtable resourceMap = new Hashtable();
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private boolean loaded = false;

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setStartToken(String startToken) {
        this.startToken = startToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public void setBundleEncoding(String bundleEncoding) {
        this.bundleEncoding = bundleEncoding;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        if (this.bundle == null) {
            throw new BuildException("The bundle attribute must be set.", this.getLocation());
        }
        if (this.startToken == null) {
            throw new BuildException("The starttoken attribute must be set.", this.getLocation());
        }
        if (this.endToken == null) {
            throw new BuildException("The endtoken attribute must be set.", this.getLocation());
        }
        if (this.bundleEncoding == null) {
            this.bundleEncoding = "Cp1252";
        }
        this.loadResourceMaps();
        this.translate();
    }

    private void loadResourceMaps() throws BuildException {
        this.processBundle(this.bundle, true);
    }

    private void processBundle(String bundleFile, boolean checkLoaded) throws BuildException {
        block2: {
            File propsFile = new File(bundleFile + ".properties");
            this.log(propsFile + "[ BUNDLE PROPERTIES FILE ]");
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(propsFile);
                this.loaded = true;
                this.log("Using " + propsFile, 4);
                this.loadResourceMap(ins);
            }
            catch (IOException ioe) {
                this.log(propsFile + " not found.", 4);
                if (this.loaded || !checkLoaded) break block2;
                throw new BuildException(ioe.getMessage());
            }
        }
    }

    private void loadResourceMap(FileInputStream ins) throws BuildException {
        try {
            BufferedReader in = null;
            InputStreamReader isr = new InputStreamReader((InputStream)ins, this.bundleEncoding);
            in = new BufferedReader(isr);
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 1 || '#' == line.charAt(0) && '!' == line.charAt(0)) continue;
                int sepIndex = line.indexOf(61);
                if (-1 == sepIndex) {
                    sepIndex = line.indexOf(58);
                }
                if (-1 == sepIndex) {
                    for (int k = 0; k < line.length(); ++k) {
                        if (!Character.isSpaceChar(line.charAt(k))) continue;
                        sepIndex = k;
                        break;
                    }
                }
                if (-1 == sepIndex) continue;
                String key = line.substring(0, sepIndex).trim();
                String value = line.substring(sepIndex + 1).trim();
                while (value.endsWith("\\")) {
                    value = value.substring(0, value.length() - 1);
                    line = in.readLine();
                    if (line == null) break;
                    value = value + line.trim();
                }
                if (key.length() <= 0 || this.resourceMap.get(key) != null) continue;
                this.resourceMap.put(key, value);
            }
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage());
        }
    }

    private void translate() throws BuildException {
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            int srcFilesCount = srcFiles.length;
            if (srcFilesCount == 1) {
                this.log("Checking 1 file in " + fs.getDir(this.getProject()), 2);
            } else {
                this.log("Checking " + srcFilesCount + " files in " + fs.getDir(this.getProject()), 2);
            }
            int bugCount = 0;
            int warningCount = 0;
            for (int j = 0; j < srcFiles.length; ++j) {
                try {
                    String line;
                    File src = this.fileUtils.resolveFile(ds.getBasedir(), srcFiles[j]);
                    this.log("Processing " + srcFiles[j], 4);
                    FileInputStream fis = new FileInputStream(src);
                    BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                    int lineNumber = 0;
                    block4: while ((line = in.readLine()) != null) {
                        ++lineNumber;
                        int startIndex = -1;
                        int endIndex = -1;
                        while ((startIndex = line.indexOf(this.startToken, endIndex + 1)) >= 0 && startIndex + 1 < line.length()) {
                            endIndex = line.indexOf(this.endToken, startIndex + 1);
                            if (endIndex < 0) {
                                this.log("\nWARNING: Line contains the start key but doesn't have the end key. ", 1);
                                this.log("WARNING: At line " + lineNumber + " in file : " + src, 1);
                                ++warningCount;
                                continue block4;
                            }
                            if ((startIndex = line.indexOf("\"", startIndex)) < 0) {
                                if (line.indexOf("this.desc") >= 0) continue block4;
                                this.log("WARNING: \"" + line + "\" does not have starting quote", 1);
                                ++warningCount;
                                continue block4;
                            }
                            endIndex = line.indexOf("\"", startIndex + 1);
                            if (endIndex < 0) {
                                this.log("WARNING: \"" + line + "\" does not have ending quote", 1);
                                ++warningCount;
                                continue block4;
                            }
                            String matches = line.substring(startIndex + 1, endIndex);
                            String replace = null;
                            replace = (String)this.resourceMap.get(matches);
                            if (replace == null) {
                                ++bugCount;
                                this.log("\nERROR: The key \"" + matches + "\" hasn't been defined.", 1);
                                this.log("ERROR: At line " + lineNumber + " in file : " + src, 1);
                                replace = matches;
                            }
                            line = line.substring(0, startIndex) + replace + line.substring(endIndex + 1);
                            endIndex = startIndex + replace.length() - 1;
                            if (endIndex + 1 < line.length()) continue;
                            continue block4;
                        }
                    }
                    if (in == null) continue;
                    in.close();
                    continue;
                }
                catch (IOException ioe) {
                    throw new BuildException(ioe.getMessage(), this.getLocation());
                }
            }
            this.log("\n###########################################");
            this.log("Total error   count: " + bugCount);
            this.log("Total warning count: " + warningCount);
        }
    }
}

