/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.AbstractNode;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.LineNumberMap;
import com.icl.saxon.tree.NodeFactory;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import com.icl.saxon.tree.SystemIdMap;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo,
Document {
    private ElementImpl documentElement;
    private Hashtable idTable = null;
    private Hashtable entityTable = null;
    private Hashtable elementList = null;
    private StringBuffer characterBuffer;
    private NamePool namePool;
    private NodeFactory nodeFactory;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();
    private Object[] index = new Object[30];
    private int indexEntriesUsed = 0;

    public DocumentImpl() {
        this.parent = null;
    }

    protected void setCharacterBuffer(StringBuffer stringBuffer) {
        this.characterBuffer = stringBuffer;
    }

    public final StringBuffer getCharacterBuffer() {
        return this.characterBuffer;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected void setDocumentElement(ElementImpl elementImpl) {
        this.documentElement = elementImpl;
    }

    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(this.sequence, string);
    }

    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.sequence);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    protected void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(n, string);
    }

    protected String getSystemId(int n) {
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(this.sequence, 0);
    }

    protected void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    protected int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final short getNodeType() {
        return 9;
    }

    public final Node getNextSibling() {
        return null;
    }

    public final Node getPreviousSibling() {
        return null;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public String generateId() {
        return "";
    }

    protected AxisEnumeration getAllElements(int n) {
        NodeSetExtent nodeSetExtent;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new Hashtable();
        }
        if ((nodeSetExtent = (NodeSetExtent)this.elementList.get(n2)) == null) {
            nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
            nodeSetExtent.setSorted(true);
            NodeImpl nodeImpl = this.getNextInDocument(this);
            while (nodeImpl != null) {
                if (nodeImpl.getNodeType() == 1 && nodeImpl.getFingerprint() == n) {
                    nodeSetExtent.append(nodeImpl);
                }
                nodeImpl = nodeImpl.getNextInDocument(this);
            }
            this.elementList.put(n2, nodeSetExtent);
        }
        return (AxisEnumeration)nodeSetExtent.enumerate();
    }

    private void indexIDs() {
        NodeImpl nodeImpl;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new Hashtable();
        DocumentImpl documentImpl = nodeImpl = this;
        while (nodeImpl != null) {
            if (((AbstractNode)nodeImpl).getNodeType() == 1) {
                ElementImpl elementImpl = (ElementImpl)nodeImpl;
                AttributeCollection attributeCollection = elementImpl.getAttributeList();
                int n = 0;
                while (n < attributeCollection.getLength()) {
                    if ("ID".equals(attributeCollection.getType(n))) {
                        this.registerID(elementImpl, attributeCollection.getValue(n));
                    }
                    ++n;
                }
            }
            nodeImpl = nodeImpl.getNextInDocument(documentImpl);
        }
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        Object v = this.idTable.get(string);
        if (v == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            this.indexIDs();
        }
        return (NodeInfo)this.idTable.get(string);
    }

    public synchronized Hashtable getKeyIndex(KeyManager keyManager, int n) {
        int n2 = 0;
        while (n2 < this.indexEntriesUsed) {
            if ((KeyManager)this.index[n2] == keyManager && (Integer)this.index[n2 + 1] == n) {
                Object object = this.index[n2 + 2];
                return (Hashtable)this.index[n2 + 2];
            }
            n2 += 3;
        }
        return null;
    }

    public synchronized void setKeyIndex(KeyManager keyManager, int n, Hashtable hashtable) {
        int n2 = 0;
        while (n2 < this.indexEntriesUsed) {
            if ((KeyManager)this.index[n2] == keyManager && (Integer)this.index[n2 + 1] == n) {
                this.index[n2 + 2] = hashtable;
                return;
            }
            n2 += 3;
        }
        if (this.indexEntriesUsed + 3 >= this.index.length) {
            Object[] objectArray = new Object[this.indexEntriesUsed * 2];
            System.arraycopy(this.index, 0, objectArray, 0, this.indexEntriesUsed);
            this.index = objectArray;
        }
        this.index[this.indexEntriesUsed++] = keyManager;
        this.index[this.indexEntriesUsed++] = new Integer(n);
        this.index[this.indexEntriesUsed++] = hashtable;
    }

    protected void setUnparsedEntity(String string, String string2) {
        if (this.entityTable == null) {
            this.entityTable = new Hashtable();
        }
        this.entityTable.put(string, string2);
    }

    public String getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return "";
        }
        String string2 = (String)this.entityTable.get(string);
        return string2 == null ? "" : string2;
    }

    public void copy(Outputter outputter) throws TransformerException {
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            nodeImpl.copy(outputter);
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
    }
}

