/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.TemplateException;
import java.io.PrintWriter;
import java.io.Writer;

public interface TemplateExceptionHandler {
    public static final TemplateExceptionHandler IGNORE_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException te, Environment env, Writer out) {
        }
    };
    public static final TemplateExceptionHandler RETHROW_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
            throw te;
        }
    };
    public static final TemplateExceptionHandler DEBUG_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
            PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
            te.printStackTrace(pw);
            pw.flush();
            throw te;
        }
    };
    public static final TemplateExceptionHandler HTML_DEBUG_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
            PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
            pw.println("<!-- FREEMARKER ERROR MESSAGE STARTS HERE --></xmp></script></noscript></style></head></pre></table></form></table></table></table><div align=left style='background-color:#FFFF00; color:#FF0000; display:block; border-top:double; padding:2pt;font-family:Arial,sans-serif'><b>FreeMarker template error!</b><pre><xmp>");
            te.printStackTrace(pw);
            pw.println("</xmp></pre></div></html>");
            pw.flush();
            throw te;
        }
    };

    public void handleTemplateException(TemplateException var1, Environment var2, Writer var3) throws TemplateException;
}

