/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.AddConcatExpression;
import freemarker.template.AndExpression;
import freemarker.template.ArithmeticExpression;
import freemarker.template.Assignment;
import freemarker.template.AssignmentInstruction;
import freemarker.template.BlockAssignment;
import freemarker.template.BodyInstruction;
import freemarker.template.BooleanLiteral;
import freemarker.template.BreakInstruction;
import freemarker.template.BuiltIn;
import freemarker.template.BuiltinVariable;
import freemarker.template.Case;
import freemarker.template.Comment;
import freemarker.template.ComparisonExpression;
import freemarker.template.CompressedBlock;
import freemarker.template.ConditionalBlock;
import freemarker.template.DollarVariable;
import freemarker.template.Dot;
import freemarker.template.DynamicKeyName;
import freemarker.template.EscapeBlock;
import freemarker.template.Expression;
import freemarker.template.FMParserConstants;
import freemarker.template.FMParserTokenManager;
import freemarker.template.FlushInstruction;
import freemarker.template.HashLiteral;
import freemarker.template.Identifier;
import freemarker.template.IfBlock;
import freemarker.template.Include;
import freemarker.template.IteratorBlock;
import freemarker.template.LibraryLoad;
import freemarker.template.ListLiteral;
import freemarker.template.Macro;
import freemarker.template.MethodCall;
import freemarker.template.MixedContent;
import freemarker.template.NoEscapeBlock;
import freemarker.template.NotExpression;
import freemarker.template.NumberLiteral;
import freemarker.template.NumericalOutput;
import freemarker.template.OrExpression;
import freemarker.template.ParentheticalExpression;
import freemarker.template.ParseException;
import freemarker.template.PropertySetting;
import freemarker.template.Range;
import freemarker.template.SimpleCharStream;
import freemarker.template.StringLiteral;
import freemarker.template.SwitchBlock;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateObject;
import freemarker.template.TextBlock;
import freemarker.template.Token;
import freemarker.template.TransformBlock;
import freemarker.template.TrimInstruction;
import freemarker.template.UnifiedCall;
import freemarker.template.utility.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

class FMParser
implements FMParserConstants {
    private Template template;
    private int loopNesting;
    private int switchNesting;
    private boolean inMacro;
    private boolean stripWhitespace;
    private LinkedList escapes = new LinkedList();
    public FMParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[66];
    private final int[] jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0x100000, 0, 0, 28672, 0, 0, 0, -1073741824, 0, 0, 0, 393216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3000000, 0, 0, 0, 0, 0, 2048, 0, 134215488, 0, 0, 0, 134215488, 134215488, 0, 0, 134215488, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 896, 196608, 30720, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x8000000, 32768, 0, 5734272, 0x38000000, 0, 0, -128483456, -128483456, -134217728, -134217728, -128483456, 0x8000000, 0, 0x3000000};
    private final int[] jj_la1_2 = new int[]{12590976, 0x20000000, 0xC00000, 0x7000000, 4161536, 0xC00000, 0xC00000, 3072, 28672, 0x3C0300, 0x3C0300, 768, 0x40000000, 0x40000000, 0x40000000, 549461888, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 32768, Integer.MIN_VALUE, 0, 0, 0, 0, 32768, 0x40000000, 0, 0, 0, 0x40000000, 0, Integer.MIN_VALUE, 0, 0, 0, 0x40000000, 549461888, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_3 = new int[]{170, 0, 0, 0, 12288, 0, 0, 0, 10, 0, 128, 0, 1, 0, 1, 170, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 0, 1152, 0, 128, 0, 8, 128, 0, 0, 16, 0, 16384, 0, 128, 0, 3072, 16, 128, 0, 170, 0, 0, 128, 3072, 0, 0, 0, 3072, 0, 0, 491520, 491520, 0, 0, 0, 0, 0, 0, 128, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[13];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace) {
        this(reader);
        this.template = template;
        this.token_source.strictEscapeSyntax = strictEscapeSyntax;
        this.stripWhitespace = stripWhitespace;
    }

    private String getErrorStart(Token t) {
        return "Error in template: " + this.template.getName() + "\non line " + t.beginLine + ", column " + t.beginColumn;
    }

    private void notStringLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof StringLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound string literal: " + exp + "\nExpecting: " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notNumberLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof NumberLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound number literal: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notBooleanLiteral(Expression exp, String expected) throws ParseException {
        if (exp == TemplateBooleanModel.TRUE || exp == TemplateBooleanModel.FALSE) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notHashLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof HashLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound hash literal: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notListLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof ListLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound list literal: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void numberLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void stringLiteralOnly(Expression exp) throws ParseException {
        this.notNumberLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void booleanLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "boolean (true/false)");
        this.notListLiteral(exp, "boolean (true/false)");
        this.notHashLiteral(exp, "boolean (true/false)");
        this.notNumberLiteral(exp, "boolean (true/false)");
    }

    private Expression escapedExpression(Expression exp) {
        if (!this.escapes.isEmpty()) {
            return ((EscapeBlock)this.escapes.getFirst()).doEscape(exp);
        }
        return exp;
    }

    public final Expression Expression() throws ParseException {
        Expression exp = this.OrExpression();
        return exp;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression PrimaryExpression() throws ParseException {
        void var1_1;
        Expression exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: 
            case 75: 
            case 86: 
            case 87: {
                exp = this.NumberLiteral();
                break;
            }
            case 101: {
                exp = this.HashLiteral();
                break;
            }
            case 71: {
                exp = this.StringLiteral();
                break;
            }
            case 72: 
            case 73: {
                exp = this.BooleanLiteral();
                break;
            }
            case 97: {
                exp = this.ListLiteral();
                break;
            }
            case 103: {
                exp = this.Identifier();
                break;
            }
            case 99: {
                exp = this.Parenthesis();
                break;
            }
            case 76: {
                exp = this.BuiltinVariable();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            exp = this.AddSubExpression(exp);
        }
        return var1_1;
    }

    public final Expression Parenthesis() throws ParseException {
        Token start = this.jj_consume_token(99);
        Expression exp = this.Expression();
        Token end = this.jj_consume_token(100);
        ParentheticalExpression result = new ParentheticalExpression(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression exp;
        boolean haveNot = false;
        Token t = null;
        Token start = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            t = this.jj_consume_token(93);
            boolean bl = haveNot = !haveNot;
            if (start != null) continue;
            start = t;
        }
        Expression result = exp = this.PrimaryExpression();
        if (haveNot) {
            this.booleanLiteralOnly(exp);
            result = new NotExpression(exp);
            result.setLocation(this.template, start, (TemplateObject)exp);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression AdditiveExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.MultiplicativeExpression();
        while (this.jj_2_2(Integer.MAX_VALUE)) {
            void var4_4;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 86: {
                    this.jj_consume_token(86);
                    boolean plus = true;
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    boolean plus = false;
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.MultiplicativeExpression();
            if (var4_4 != false) {
                result = new AddConcatExpression(lhs, rhs);
            } else {
                this.numberLiteralOnly(lhs);
                this.numberLiteralOnly(rhs);
                result = new ArithmeticExpression(lhs, rhs, 0);
            }
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression lhs;
        int operation = 1;
        Expression result = lhs = this.UnaryExpression();
        while (this.jj_2_3(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    this.jj_consume_token(88);
                    operation = 1;
                    break;
                }
                case 89: {
                    this.jj_consume_token(89);
                    operation = 2;
                    break;
                }
                case 90: {
                    this.jj_consume_token(90);
                    operation = 3;
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.UnaryExpression();
            this.numberLiteralOnly(lhs);
            this.numberLiteralOnly(rhs);
            result = new ArithmeticExpression(lhs, rhs, operation);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression Comparison() throws ParseException {
        Expression lhs;
        boolean equality = false;
        Expression result = lhs = this.AdditiveExpression();
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            void var4_4;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    Token t = this.jj_consume_token(81);
                    equality = true;
                    break;
                }
                case 79: {
                    Token t = this.jj_consume_token(79);
                    equality = true;
                    break;
                }
                case 80: {
                    Token t = this.jj_consume_token(80);
                    equality = true;
                    break;
                }
                case 109: {
                    Token t = this.jj_consume_token(109);
                    break;
                }
                case 85: {
                    Token t = this.jj_consume_token(85);
                    break;
                }
                case 108: {
                    Token t = this.jj_consume_token(108);
                    break;
                }
                case 84: {
                    Token t = this.jj_consume_token(84);
                    break;
                }
                case 83: {
                    Token t = this.jj_consume_token(83);
                    break;
                }
                case 82: {
                    Token t = this.jj_consume_token(82);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.AdditiveExpression();
            this.notHashLiteral(lhs, "scalar");
            this.notHashLiteral(rhs, "scalar");
            this.notListLiteral(lhs, "scalar");
            this.notListLiteral(rhs, "scalar");
            if (!equality) {
                this.notStringLiteral(lhs, "number");
                this.notStringLiteral(rhs, "number");
            }
            result = new ComparisonExpression(lhs, rhs, var4_4.image);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression AndExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.Comparison();
        while (this.jj_2_5(Integer.MAX_VALUE)) {
            this.jj_consume_token(91);
            Expression rhs = this.Comparison();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new AndExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression OrExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.AndExpression();
        while (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(92);
            Expression rhs = this.AndExpression();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new OrExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final ListLiteral ListLiteral() throws ParseException {
        ArrayList values = new ArrayList();
        Token begin = this.jj_consume_token(97);
        values = this.PositionalArgs();
        Token end = this.jj_consume_token(98);
        ListLiteral result = new ListLiteral(values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression NumberLiteral() throws ParseException {
        void var2_3;
        Token op = null;
        boolean minus = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: 
            case 87: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 86: {
                        op = this.jj_consume_token(86);
                        minus = false;
                        break block0;
                    }
                    case 87: {
                        op = this.jj_consume_token(87);
                        minus = true;
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                Token t = this.jj_consume_token(74);
                break;
            }
            case 75: {
                Token t = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s = var2_3.image;
        if (minus) {
            s = "-" + s;
        }
        NumberLiteral result = new NumberLiteral(this.template.getArithmeticEngine().toNumber(s));
        Token startToken = op != null ? op : var2_3;
        result.setLocation(this.template, startToken, (Token)var2_3);
        return result;
    }

    public final Range Range(Expression lhs) throws ParseException {
        this.jj_consume_token(77);
        Expression rhs = this.Expression();
        this.numberLiteralOnly(lhs);
        this.numberLiteralOnly(rhs);
        Range range = new Range(lhs, rhs);
        range.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        return range;
    }

    public final Identifier Identifier() throws ParseException {
        Token t = this.jj_consume_token(103);
        Identifier id = new Identifier(t.image);
        id.setLocation(this.template, t, t);
        return id;
    }

    public final BuiltinVariable BuiltinVariable() throws ParseException {
        Token dot = this.jj_consume_token(76);
        Token name = this.jj_consume_token(103);
        BuiltinVariable result = null;
        try {
            result = new BuiltinVariable(name.image);
        }
        catch (ParseException pe) {
            pe.lineNumber = dot.beginLine;
            pe.columnNumber = dot.beginColumn;
            throw pe;
        }
        result.setLocation(this.template, dot, name);
        return result;
    }

    public final Expression AddSubExpression(Expression exp) throws ParseException {
        Expression result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                result = this.DotVariable(exp);
                break;
            }
            case 97: {
                result = this.DynamicKey(exp);
                break;
            }
            case 99: {
                result = this.MethodArgs(exp);
                break;
            }
            case 78: {
                result = this.BuiltIn(exp);
                break;
            }
            case 77: {
                result = this.Range(exp);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Expression BuiltIn(Expression exp) throws ParseException {
        Token t = null;
        this.jj_consume_token(78);
        t = this.jj_consume_token(103);
        BuiltIn result = null;
        try {
            result = BuiltIn.newBuiltIn(exp, t.image);
        }
        catch (ParseException pe) {
            pe.lineNumber = t.beginLine;
            pe.columnNumber = t.beginColumn;
            throw pe;
        }
        result.setLocation(this.template, (TemplateObject)exp, t);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression DotVariable(Expression exp) throws ParseException {
        void var2_2;
        this.jj_consume_token(76);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 103: {
                Token t = this.jj_consume_token(103);
                break;
            }
            case 72: 
            case 73: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: {
                        t = this.jj_consume_token(82);
                        break;
                    }
                    case 83: {
                        t = this.jj_consume_token(83);
                        break;
                    }
                    case 84: {
                        t = this.jj_consume_token(84);
                        break;
                    }
                    case 85: {
                        t = this.jj_consume_token(85);
                        break;
                    }
                    case 72: {
                        t = this.jj_consume_token(72);
                        break;
                    }
                    case 73: {
                        t = this.jj_consume_token(73);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (Character.isLetter(var2_2.image.charAt(0))) break;
                String msg = this.getErrorStart((Token)var2_2) + "\n" + var2_2.image + " is not a valid identifier.";
                throw new ParseException(msg, var2_2.beginLine, var2_2.beginColumn);
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.notListLiteral(exp, "hash");
        this.notStringLiteral(exp, "hash");
        this.notBooleanLiteral(exp, "hash");
        Dot dot = new Dot(exp, var2_2.image);
        dot.setLocation(this.template, (TemplateObject)exp, (Token)var2_2);
        return dot;
    }

    public final Expression DynamicKey(Expression exp) throws ParseException {
        this.jj_consume_token(97);
        Expression arg = this.Expression();
        Token t = this.jj_consume_token(98);
        this.notBooleanLiteral(exp, "list or hash");
        this.notNumberLiteral(exp, "list or hash");
        DynamicKeyName dkn = new DynamicKeyName(exp, arg);
        dkn.setLocation(this.template, (TemplateObject)exp, t);
        return dkn;
    }

    public final MethodCall MethodArgs(Expression exp) throws ParseException {
        ArrayList args = new ArrayList();
        this.jj_consume_token(99);
        args = this.PositionalArgs();
        Token end = this.jj_consume_token(100);
        args.trimToSize();
        MethodCall result = new MethodCall(exp, args);
        result.setLocation(this.template, (TemplateObject)exp, end);
        return result;
    }

    public final Expression StringLiteral() throws ParseException {
        Token t = this.jj_consume_token(71);
        String s = t.image;
        s = s.substring(1, s.length() - 1);
        try {
            s = StringUtil.FTLStringLiteralDec(s);
        }
        catch (ParseException pe) {
            pe.lineNumber = t.beginLine;
            pe.columnNumber = t.beginColumn;
            throw pe;
        }
        StringLiteral result = new StringLiteral(s);
        result.setLocation(this.template, t, t);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression BooleanLiteral() throws ParseException {
        void var1_1;
        void var2_2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                Token t = this.jj_consume_token(72);
                BooleanLiteral result = new BooleanLiteral(false);
                break;
            }
            case 73: {
                Token t = this.jj_consume_token(73);
                BooleanLiteral result = new BooleanLiteral(true);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        var2_2.setLocation(this.template, (Token)var1_1, (Token)var1_1);
        return var2_2;
    }

    public final HashLiteral HashLiteral() throws ParseException {
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        Token begin = this.jj_consume_token(101);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 86: 
            case 87: 
            case 93: 
            case 97: 
            case 99: 
            case 101: 
            case 103: {
                Expression key = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 94: {
                        this.jj_consume_token(94);
                        break;
                    }
                    case 96: {
                        this.jj_consume_token(96);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression value = this.Expression();
                this.stringLiteralOnly(key);
                keys.add(key);
                values.add(value);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 94: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(94);
                    key = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 94: {
                            this.jj_consume_token(94);
                            break;
                        }
                        case 96: {
                            this.jj_consume_token(96);
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    value = this.Expression();
                    this.stringLiteralOnly(key);
                    keys.add(key);
                    values.add(value);
                }
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(102);
        HashLiteral result = new HashLiteral(keys, values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final DollarVariable StringOutput() throws ParseException {
        Token begin = this.jj_consume_token(62);
        Expression exp = this.Expression();
        this.notHashLiteral(exp, "scalar");
        this.notListLiteral(exp, "scalar");
        this.notBooleanLiteral(exp, "scalar");
        Token end = this.jj_consume_token(102);
        DollarVariable result = new DollarVariable(exp, this.escapedExpression(exp));
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final NumericalOutput NumericalOutput() throws ParseException {
        NumericalOutput result;
        Token fmt = null;
        Token begin = this.jj_consume_token(63);
        Expression exp = this.Expression();
        this.numberLiteralOnly(exp);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                this.jj_consume_token(95);
                fmt = this.jj_consume_token(103);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(102);
        if (fmt != null) {
            String msg;
            int minFrac = -1;
            int maxFrac = -1;
            StringTokenizer st = new StringTokenizer(fmt.image, "mM", true);
            int type = 45;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    if (type != 45) {
                        switch (type) {
                            case 109: {
                                if (minFrac != -1) {
                                    throw new ParseException("invalid formatting string", fmt.beginLine, fmt.beginColumn);
                                }
                                minFrac = Integer.parseInt(token);
                                break;
                            }
                            case 77: {
                                if (maxFrac != -1) {
                                    throw new ParseException("invalid formatting string", fmt.beginLine, fmt.beginColumn);
                                }
                                maxFrac = Integer.parseInt(token);
                                break;
                            }
                            default: {
                                throw new ParseException();
                            }
                        }
                        type = 45;
                        continue;
                    }
                    if (token.equals("m")) {
                        type = 109;
                        continue;
                    }
                    if (token.equals("M")) {
                        type = 77;
                        continue;
                    }
                    throw new ParseException();
                }
                catch (ParseException e) {
                    String msg2 = this.getErrorStart(fmt) + "\nInvalid format specifier " + fmt.image;
                    throw new ParseException(msg2, fmt.beginLine, fmt.beginColumn);
                }
                catch (NumberFormatException e) {
                    String msg3 = this.getErrorStart(fmt) + "\nInvalid number in the format specifier " + fmt.image;
                    throw new ParseException(msg3, fmt.beginLine, fmt.beginColumn);
                }
            }
            if (maxFrac == -1) {
                if (minFrac == -1) {
                    msg = this.getErrorStart(fmt) + "\nInvalid format specification, at least one of m and M must be specified!";
                    throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
                }
                maxFrac = minFrac;
            } else if (minFrac == -1) {
                minFrac = 0;
            }
            if (minFrac > maxFrac) {
                msg = this.getErrorStart(fmt) + "\nInvalid format specification, min cannot be greater than max!";
                throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
            }
            if (minFrac > 50 || maxFrac > 50) {
                msg = this.getErrorStart(fmt) + "\nCannot specify more than 50 fraction digits";
                throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
            }
            result = new NumericalOutput(exp, minFrac, maxFrac);
        } else {
            result = new NumericalOutput(exp);
        }
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final TemplateElement If() throws ParseException {
        Token t;
        Token start = this.jj_consume_token(6);
        Expression condition = this.Expression();
        this.jj_consume_token(106);
        TemplateElement block = this.OptionalBlock();
        ConditionalBlock cblock = new ConditionalBlock(condition, block, true);
        cblock.setLocation(this.template, start, (TemplateObject)block);
        IfBlock ifBlock = new IfBlock(cblock);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block6;
                }
            }
            t = this.jj_consume_token(7);
            condition = this.Expression();
            this.jj_consume_token(106);
            block = this.OptionalBlock();
            cblock = new ConditionalBlock(condition, block, false);
            cblock.setLocation(this.template, t, (TemplateObject)block);
            ifBlock.addBlock(cblock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                t = this.jj_consume_token(38);
                block = this.OptionalBlock();
                cblock = new ConditionalBlock(null, block, false);
                cblock.setLocation(this.template, t, (TemplateObject)block);
                ifBlock.addBlock(cblock);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(27);
        ifBlock.setLocation(this.template, start, end);
        return ifBlock;
    }

    public final IteratorBlock List() throws ParseException {
        Token start = this.jj_consume_token(8);
        ++this.loopNesting;
        Expression exp = this.Expression();
        Token as = this.jj_consume_token(103);
        if (!"as".equals(as.image)) {
            throw new ParseException("Expecting \"as\" here.", as.beginLine, as.beginColumn);
        }
        Token index = this.jj_consume_token(103);
        this.jj_consume_token(106);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(28);
        --this.loopNesting;
        IteratorBlock result = new IteratorBlock(exp, index.image, block, false);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final IteratorBlock ForEach() throws ParseException {
        Token start = this.jj_consume_token(9);
        ++this.loopNesting;
        Token index = this.jj_consume_token(103);
        Token in = this.jj_consume_token(103);
        if (!"in".equals(in.image)) {
            throw new ParseException("Expecting \"in\" here.", in.beginLine, in.beginColumn);
        }
        Expression exp = this.Expression();
        this.jj_consume_token(106);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(29);
        --this.loopNesting;
        IteratorBlock result = new IteratorBlock(exp, index.image, block, true);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final BreakInstruction Break() throws ParseException {
        void var2_4;
        int type = 2;
        Token end = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                Token start = this.jj_consume_token(39);
                if (this.loopNesting < 1 && this.switchNesting < 1) {
                    String msg = this.getErrorStart(start) + "\n" + start.image + " occurred outside a loop or a switch block.";
                    throw new ParseException(msg, start.beginLine, start.beginColumn);
                }
                type = 0;
                break;
            }
            case 40: {
                Token start = this.jj_consume_token(40);
                if (!this.inMacro) {
                    String msg = this.getErrorStart(start) + "\n" + start.image + " occurred outside a macro.";
                    throw new ParseException(msg, start.beginLine, start.beginColumn);
                }
                type = 1;
                break;
            }
            case 41: {
                Token start = this.jj_consume_token(41);
                break;
            }
            case 20: {
                Token start = this.jj_consume_token(20);
                exp = this.Expression();
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (end == null) {
            end = var2_4;
        }
        BreakInstruction result = exp != null ? new BreakInstruction(exp) : new BreakInstruction(type);
        result.setLocation(this.template, (Token)var2_4, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Nested() throws ParseException {
        BodyInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                Token t = this.jj_consume_token(48);
                result = new BodyInstruction(null);
                result.setLocation(this.template, t, t);
                break;
            }
            case 49: {
                Token t = this.jj_consume_token(49);
                ArrayList bodyParameters = this.PositionalArgs();
                Token end = this.LooseDirectiveEnd();
                result = new BodyInstruction(bodyParameters);
                result.setLocation(this.template, t, end);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.inMacro) {
            void var1_2;
            throw new ParseException(this.getErrorStart((Token)var1_2) + "\nCannot use a " + var1_2.image + " instruction outside a macro.", var1_2.beginLine, var1_2.beginColumn);
        }
        return result;
    }

    public final TemplateElement Flush() throws ParseException {
        Token t = this.jj_consume_token(42);
        FlushInstruction result = new FlushInstruction();
        result.setLocation(this.template, t, t);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Trim() throws ParseException {
        void var1_2;
        TrimInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                Token t = this.jj_consume_token(43);
                result = new TrimInstruction(true, true);
                break;
            }
            case 44: {
                Token t = this.jj_consume_token(44);
                result = new TrimInstruction(true, false);
                break;
            }
            case 45: {
                Token t = this.jj_consume_token(45);
                result = new TrimInstruction(false, true);
                break;
            }
            case 46: {
                Token t = this.jj_consume_token(46);
                result = new TrimInstruction(false, false);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.setLocation(this.template, (Token)var1_2, (Token)var1_2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Assign() throws ParseException {
        Expression nsExp = null;
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                Token start = this.jj_consume_token(12);
                int scope = 1;
                break;
            }
            case 13: {
                Token start = this.jj_consume_token(13);
                int scope = 3;
                break;
            }
            case 14: {
                Token start = this.jj_consume_token(14);
                int scope = 2;
                scope = 2;
                if (this.inMacro) break;
                String msg = this.getErrorStart(start) + "\nLocal variable assigned outside a macro.";
                throw new ParseException(msg, start.beginLine, start.beginColumn);
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token id = this.jj_consume_token(103);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                void var1_3;
                void var3_4;
                this.jj_consume_token(79);
                Expression exp = this.Expression();
                Assignment ass = new Assignment(id.image, exp, (int)var3_4);
                ass.setLocation(this.template, id, (TemplateObject)exp);
                assignments.add(ass);
                while (this.jj_2_7(Integer.MAX_VALUE)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 94: {
                            this.jj_consume_token(94);
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                        }
                    }
                    id = this.jj_consume_token(103);
                    this.jj_consume_token(79);
                    exp = this.Expression();
                    ass = new Assignment(id.image, exp, (int)var3_4);
                    ass.setLocation(this.template, id, (TemplateObject)exp);
                    assignments.add(ass);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 103: {
                        Token in = this.jj_consume_token(103);
                        if (!in.image.equals("in")) {
                            throw new ParseException(this.getErrorStart(in) + "\nExpecting 'in' here followed by namespace.", in.beginLine, in.beginColumn);
                        }
                        nsExp = this.Expression();
                        if (var3_4 == true) break;
                        throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.beginLine, id.beginColumn);
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                Token end = this.LooseDirectiveEnd();
                AssignmentInstruction ai = new AssignmentInstruction((int)var3_4);
                for (int i = 0; i < assignments.size(); ++i) {
                    ai.addAssignment((Assignment)assignments.get(i));
                }
                ai.setNamespaceExp(nsExp);
                ai.setLocation(this.template, (Token)var1_3, end);
                return ai;
            }
            case 103: 
            case 106: {
                void var2_13;
                void var1_3;
                void var3_4;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 103: {
                        Token in = this.jj_consume_token(103);
                        if (!in.image.equals("in")) {
                            throw new ParseException(this.getErrorStart(in) + "\nExpecting 'in' here followed by namespace.", in.beginLine, in.beginColumn);
                        }
                        nsExp = this.Expression();
                        if (var3_4 == true) break;
                        throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.beginLine, id.beginColumn);
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                this.jj_consume_token(106);
                TemplateElement block = this.OptionalBlock();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        Token end = this.jj_consume_token(30);
                        if (var3_4 == 2) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.beginLine, end.beginColumn);
                    }
                    case 32: {
                        Token end = this.jj_consume_token(32);
                        if (var3_4 == true) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.beginLine, end.beginColumn);
                    }
                    case 31: {
                        Token end = this.jj_consume_token(31);
                        if (var3_4 == 3) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags", end.beginLine, end.beginColumn);
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BlockAssignment ba = new BlockAssignment(block, id.image, (int)var3_4, nsExp);
                ba.setLocation(this.template, (Token)var1_3, (Token)var2_13);
                return ba;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Include Include() throws ParseException {
        Expression nameExp;
        Token start;
        Expression encodingExp;
        Expression parseExp;
        block8: {
            Token att;
            parseExp = null;
            encodingExp = null;
            start = this.jj_consume_token(15);
            nameExp = this.Expression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    this.jj_consume_token(95);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 103: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block8;
                    }
                }
                att = this.jj_consume_token(103);
                this.jj_consume_token(79);
                Expression exp = this.Expression();
                String attString = att.image;
                if (attString.equalsIgnoreCase("parse")) {
                    parseExp = exp;
                    continue;
                }
                if (!attString.equalsIgnoreCase("encoding")) break;
                encodingExp = exp;
            }
            String msg = this.getErrorStart(att) + "\nexpecting parse= or encoding= to be specified.";
            throw new ParseException(msg, att.beginLine, att.beginColumn);
        }
        Token end = this.LooseDirectiveEnd();
        Include result = new Include(this.template, nameExp, encodingExp, parseExp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final LibraryLoad Import() throws ParseException {
        Token start = this.jj_consume_token(16);
        Expression nameExp = this.Expression();
        Token as = this.jj_consume_token(103);
        if (!as.image.equals("as")) {
            throw new ParseException(this.getErrorStart(as) + "\nExpecting \"as\" here.", as.beginLine, as.beginColumn);
        }
        Token ns = this.jj_consume_token(103);
        Token end = this.LooseDirectiveEnd();
        LibraryLoad result = new LibraryLoad(this.template, nameExp, ns.image);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Macro Macro() throws ParseException {
        void var4_11;
        void var3_7;
        ArrayList<String> argNames = new ArrayList<String>();
        HashMap<String, Expression> args = new HashMap<String, Expression>();
        ArrayList<String> defNames = new ArrayList<String>();
        Expression defValue = null;
        boolean isFunction = false;
        boolean hasDefaults = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                Token start = this.jj_consume_token(18);
                break;
            }
            case 17: {
                Token start = this.jj_consume_token(17);
                isFunction = true;
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro) {
            throw new ParseException(this.getErrorStart((Token)var3_7) + "\nMacros cannot be nested.", var3_7.beginLine, var3_7.endLine);
        }
        this.inMacro = true;
        Token name = this.jj_consume_token(103);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block23;
                }
            }
            Token arg = this.jj_consume_token(103);
            argNames.add(arg.image);
            defValue = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 79: {
                    this.jj_consume_token(79);
                    defValue = this.Expression();
                    defNames.add(arg.image);
                    hasDefaults = true;
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: {
                    this.jj_consume_token(94);
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                }
            }
            if (hasDefaults && defValue == null) {
                throw new ParseException(this.getErrorStart(arg) + "\nIn a macro declaration, parameters without a default value " + "must all occur before the parameters with default values.", arg.beginLine, arg.endLine);
            }
            args.put(arg.image, defValue);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        this.jj_consume_token(106);
        TemplateElement block = this.OptionalBlock();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                Token end = this.jj_consume_token(34);
                if (!isFunction) break;
                throw new ParseException(this.getErrorStart((Token)var3_7) + "\nExpected function end tag here.", var3_7.beginLine, var3_7.endLine);
            }
            case 33: {
                Token end = this.jj_consume_token(33);
                if (isFunction) break;
                throw new ParseException(this.getErrorStart((Token)var3_7) + "\nExpected macro end tag here.", var3_7.beginLine, var3_7.endLine);
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.inMacro = false;
        Macro result = new Macro(name.image, argNames, args, block);
        result.setLocation(this.template, (Token)var3_7, (Token)var4_11);
        this.template.addMacro(result);
        return result;
    }

    public final CompressedBlock Compress() throws ParseException {
        Token start = this.jj_consume_token(23);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(35);
        CompressedBlock cb = new CompressedBlock(block);
        cb.setLocation(this.template, start, end);
        return cb;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement UnifiedMacroTransform() throws ParseException {
        void var2_9;
        Token start = null;
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        ArrayList<String> bodyParameters = null;
        String directiveName = null;
        TemplateElement nestedBlock = null;
        start = this.jj_consume_token(54);
        Expression exp = this.Expression();
        if (exp instanceof Identifier || exp instanceof Dot && ((Dot)exp).onlyHasIdentifiers()) {
            directiveName = exp.getCanonicalForm();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            positionalArgs = this.PositionalArgs();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                this.jj_consume_token(95);
                bodyParameters = new ArrayList<String>();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 103: {
                        Token t = this.jj_consume_token(103);
                        bodyParameters.add(t.image);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 94: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[38] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(94);
                            t = this.jj_consume_token(103);
                            bodyParameters.add(t.image);
                        }
                    }
                }
                this.jj_la1[39] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: {
                Token end = this.jj_consume_token(107);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                nestedBlock = this.OptionalBlock();
                Token end = this.jj_consume_token(55);
                String s = end.image.substring(3);
                s = s.substring(0, s.length() - 1).trim();
                if (s.length() <= 0 || s.equals(directiveName)) break;
                String msg = this.getErrorStart(end);
                if (directiveName == null) {
                    throw new ParseException(msg + "\nExpecting </@>", end.beginLine, end.beginColumn);
                }
                throw new ParseException(msg + "\nExpecting </@> or </@" + directiveName + ">", end.beginLine, end.beginColumn);
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        UnifiedCall result = positionalArgs != null ? new UnifiedCall(exp, positionalArgs, nestedBlock, bodyParameters) : new UnifiedCall(exp, namedArgs, nestedBlock, bodyParameters);
        result.setLocation(this.template, start, (Token)var2_9);
        return result;
    }

    public final TemplateElement Call() throws ParseException {
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        String macroName = null;
        Token start = this.jj_consume_token(21);
        Token id = this.jj_consume_token(103);
        macroName = id.image;
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            if (this.jj_2_9(Integer.MAX_VALUE)) {
                this.jj_consume_token(99);
            }
            positionalArgs = this.PositionalArgs();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 100: {
                    this.jj_consume_token(100);
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                }
            }
        }
        Token end = this.LooseDirectiveEnd();
        UnifiedCall result = null;
        result = positionalArgs != null ? new UnifiedCall((Expression)new Identifier(macroName), positionalArgs, null, null) : new UnifiedCall((Expression)new Identifier(macroName), namedArgs, null, null);
        result.notransform = true;
        result.setLocation(this.template, start, end);
        return result;
    }

    public final HashMap NamedArgs() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block3: while (true) {
            Token t = this.jj_consume_token(103);
            this.jj_consume_token(79);
            Expression exp = this.Expression();
            result.put(t.image, exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[43] = this.jj_gen;
        return result;
    }

    public final ArrayList PositionalArgs() throws ParseException {
        ArrayList<Expression> result = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 86: 
            case 87: 
            case 93: 
            case 97: 
            case 99: 
            case 101: 
            case 103: {
                Expression arg = this.Expression();
                result.add(arg);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 94: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(94);
                    arg = this.Expression();
                    result.add(arg);
                }
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Comment Comment() throws ParseException {
        void var1_2;
        StringBuffer buf = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                Token start = this.jj_consume_token(24);
                break;
            }
            case 25: {
                Token start = this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token end = this.UnparsedContent(buf);
        Comment result = new Comment(buf.toString());
        result.setLocation(this.template, (Token)var1_2, end);
        return result;
    }

    public final TextBlock NoParse() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token start = this.jj_consume_token(26);
        Token end = this.UnparsedContent(buf);
        TextBlock result = new TextBlock(buf.toString(), true);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TransformBlock Transform() throws ParseException {
        void var2_7;
        TemplateElement content = null;
        HashMap<String, Expression> args = null;
        Token start = this.jj_consume_token(19);
        Expression exp = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    break block10;
                }
            }
            Token argName = this.jj_consume_token(103);
            this.jj_consume_token(79);
            Expression argExp = this.Expression();
            if (args == null) {
                args = new HashMap<String, Expression>();
            }
            args.put(argName.image, argExp);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: {
                Token end = this.jj_consume_token(107);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                content = this.OptionalBlock();
                Token end = this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TransformBlock result = new TransformBlock(exp, args, content);
        result.setLocation(this.template, start, (Token)var2_7);
        return result;
    }

    public final SwitchBlock Switch() throws ParseException {
        boolean defaultFound = false;
        Token start = this.jj_consume_token(10);
        Expression switchExp = this.Expression();
        this.jj_consume_token(106);
        ++this.switchNesting;
        SwitchBlock switchBlock = new SwitchBlock(switchExp);
        while (this.jj_2_11(2)) {
            Case caseIns = this.Case();
            if (caseIns.isDefault) {
                if (defaultFound) {
                    String msg = this.getErrorStart(start) + "\nYou can only have one default case in a switch statement";
                    throw new ParseException(msg, start.beginLine, start.beginColumn);
                }
                defaultFound = true;
            }
            switchBlock.addCase(caseIns);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(37);
        --this.switchNesting;
        switchBlock.setLocation(this.template, start, end);
        return switchBlock;
    }

    /*
     * WARNING - void declaration
     */
    public final Case Case() throws ParseException {
        void var4_3;
        Expression exp = null;
        boolean isDefault = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                Token start = this.jj_consume_token(11);
                exp = this.Expression();
                this.jj_consume_token(106);
                break;
            }
            case 47: {
                Token start = this.jj_consume_token(47);
                isDefault = true;
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TemplateElement block = this.OptionalBlock();
        Case result = new Case(exp, block, isDefault);
        result.setLocation(this.template, (Token)var4_3, (TemplateObject)block);
        return result;
    }

    public final EscapeBlock Escape() throws ParseException {
        Token start = this.jj_consume_token(50);
        Token variable = this.jj_consume_token(103);
        Token as = this.jj_consume_token(103);
        if (!"as".equals(as.image)) {
            throw new ParseException("Expecting \"as\" here.", as.beginLine, as.beginColumn);
        }
        Expression escapeExpr = this.Expression();
        this.jj_consume_token(106);
        EscapeBlock result = new EscapeBlock(variable.image, escapeExpr, this.escapedExpression(escapeExpr));
        this.escapes.addFirst(result);
        TemplateElement content = this.OptionalBlock();
        result.setContent(content);
        this.escapes.removeFirst();
        Token end = this.jj_consume_token(51);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final NoEscapeBlock NoEscape() throws ParseException {
        Token start = this.jj_consume_token(52);
        if (this.escapes.isEmpty()) {
            String msg = this.getErrorStart(start) + "\nnoescape with no matching escape encountered.";
            throw new ParseException(msg, start.beginLine, start.beginColumn);
        }
        Object escape = this.escapes.removeFirst();
        TemplateElement content = this.OptionalBlock();
        Token end = this.jj_consume_token(53);
        this.escapes.addFirst(escape);
        NoEscapeBlock result = new NoEscapeBlock(content);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Token LooseDirectiveEnd() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                Token t = this.jj_consume_token(106);
                break;
            }
            case 107: {
                Token t = this.jj_consume_token(107);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    public final PropertySetting Setting() throws ParseException {
        Token start = this.jj_consume_token(22);
        Token key = this.jj_consume_token(103);
        this.jj_consume_token(79);
        Expression value = this.Expression();
        Token end = this.LooseDirectiveEnd();
        PropertySetting result = new PropertySetting(key.image, value);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement FreemarkerDirective() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                TemplateElement tp = this.If();
                break;
            }
            case 8: {
                TemplateElement tp = this.List();
                break;
            }
            case 9: {
                TemplateElement tp = this.ForEach();
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                TemplateElement tp = this.Assign();
                break;
            }
            case 15: {
                TemplateElement tp = this.Include();
                break;
            }
            case 16: {
                TemplateElement tp = this.Import();
                break;
            }
            case 17: 
            case 18: {
                TemplateElement tp = this.Macro();
                break;
            }
            case 23: {
                TemplateElement tp = this.Compress();
                break;
            }
            case 54: {
                TemplateElement tp = this.UnifiedMacroTransform();
                break;
            }
            case 21: {
                TemplateElement tp = this.Call();
                break;
            }
            case 24: 
            case 25: {
                TemplateElement tp = this.Comment();
                break;
            }
            case 26: {
                TemplateElement tp = this.NoParse();
                break;
            }
            case 19: {
                TemplateElement tp = this.Transform();
                break;
            }
            case 10: {
                TemplateElement tp = this.Switch();
                break;
            }
            case 22: {
                TemplateElement tp = this.Setting();
                break;
            }
            case 20: 
            case 39: 
            case 40: 
            case 41: {
                TemplateElement tp = this.Break();
                break;
            }
            case 42: {
                TemplateElement tp = this.Flush();
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                TemplateElement tp = this.Trim();
                break;
            }
            case 48: 
            case 49: {
                TemplateElement tp = this.Nested();
                break;
            }
            case 50: {
                TemplateElement tp = this.Escape();
                break;
            }
            case 52: {
                TemplateElement tp = this.NoEscape();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final TextBlock PCData() throws ParseException {
        void var2_3;
        StringBuffer buf = new StringBuffer();
        Token start = null;
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    Token t = this.jj_consume_token(59);
                    break;
                }
                case 60: {
                    Token t = this.jj_consume_token(60);
                    break;
                }
                case 61: {
                    Token t = this.jj_consume_token(61);
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(var2_3.image);
            if (start != null) continue;
            start = var2_3;
        } while (this.jj_2_12(Integer.MAX_VALUE));
        TextBlock result = new TextBlock(buf.toString(), false);
        result.setLocation(this.template, start, (Token)var2_3);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Token UnparsedContent(StringBuffer buf) throws ParseException {
        void var2_2;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: {
                    Token t = this.jj_consume_token(113);
                    break;
                }
                case 112: {
                    Token t = this.jj_consume_token(112);
                    break;
                }
                case 111: {
                    Token t = this.jj_consume_token(111);
                    break;
                }
                case 114: {
                    Token t = this.jj_consume_token(114);
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(var2_2.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 111: 
                case 112: 
                case 113: 
                case 114: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[57] = this.jj_gen;
        buf.setLength(buf.length() - var2_2.image.length());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Content() throws ParseException {
        void var2_3;
        MixedContent nodes = new MixedContent();
        TemplateObject begin = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: 
                case 60: 
                case 61: {
                    TemplateElement elem = this.PCData();
                    break;
                }
                case 62: {
                    TemplateElement elem = this.StringOutput();
                    break;
                }
                case 63: {
                    TemplateElement elem = this.NumericalOutput();
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 52: 
                case 54: {
                    TemplateElement elem = this.FreemarkerDirective();
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = var2_3;
            }
            nodes.addElement((TemplateElement)var2_3);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 52: 
                case 54: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[59] = this.jj_gen;
        nodes.setLocation(this.template, begin, (TemplateObject)var2_3);
        return nodes;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement FreeMarkerText() throws ParseException {
        void var2_3;
        MixedContent nodes = new MixedContent();
        TemplateObject begin = null;
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: 
                case 60: 
                case 61: {
                    TemplateElement elem = this.PCData();
                    break;
                }
                case 62: {
                    TemplateElement elem = this.StringOutput();
                    break;
                }
                case 63: {
                    TemplateElement elem = this.NumericalOutput();
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = var2_3;
            }
            nodes.addElement((TemplateElement)var2_3);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[61] = this.jj_gen;
        nodes.setLocation(this.template, begin, (TemplateObject)var2_3);
        return nodes;
    }

    public final TemplateElement OptionalBlock() throws ParseException {
        TemplateElement tp = TextBlock.EMPTY_BLOCK;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                tp = this.Content();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        return tp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map HeaderElement() throws ParseException {
        HashMap<String, String> result = new HashMap<String, String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                return result;
            }
            case 56: {
                this.jj_consume_token(56);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 103: {
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                            break block16;
                        }
                    }
                    Token key = this.jj_consume_token(103);
                    this.jj_consume_token(79);
                    Token value = this.jj_consume_token(71);
                    String ks = key.image;
                    String vs = value.image;
                    vs = vs.substring(1, vs.length() - 1);
                    try {
                        vs = StringUtil.FTLStringLiteralDec(vs);
                    }
                    catch (ParseException pe) {
                        pe.lineNumber = value.beginLine;
                        pe.columnNumber = value.beginColumn;
                        throw pe;
                    }
                    result.put(ks, vs);
                    if (this.template == null) continue;
                    if (ks.equalsIgnoreCase("encoding")) {
                        String encoding = this.template.getEncoding();
                        if (encoding == null || encoding.equals(vs)) continue;
                        throw new Template.WrongEncodingException(vs);
                    }
                    if (ks.equalsIgnoreCase("STRIP_WHITESPACE")) {
                        try {
                            this.stripWhitespace = StringUtil.getYesNo(vs);
                        }
                        catch (IllegalArgumentException iae) {
                            throw new ParseException("Error in ftl header element, expecting yes or no, found: " + vs, key.beginLine, key.beginColumn);
                        }
                    }
                    if (!ks.equalsIgnoreCase("STRICT_SYNTAX")) throw new ParseException("unknown ftl header setting: " + key.image, key.beginLine, key.beginColumn);
                    try {
                        this.token_source.strictEscapeSyntax = StringUtil.getYesNo(vs);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ParseException("Error in ftl header element, expecting yes or no, found: " + vs, key.beginLine, key.beginColumn);
                    }
                }
                this.LooseDirectiveEnd();
                return result;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TemplateElement Root() throws ParseException {
        if (this.jj_2_13(Integer.MAX_VALUE)) {
            Map headerParams = this.HeaderElement();
            this.template.setHeaderParameters(headerParams);
        }
        TemplateElement doc = this.OptionalBlock();
        this.jj_consume_token(0);
        doc.setParentRecursively(null);
        return doc.postParseCleanup(this.stripWhitespace);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_28()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_3R_69()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_3R_68()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_135() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_3R_66()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_65()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_117() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_61()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_62()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_63()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_135()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_117()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_118()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        Token xsp;
        block3: {
            if (this.jj_3R_58()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_58()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_129() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_150() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_24()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_25()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_26()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_127() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_45()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_143() {
        if (this.jj_3R_151()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_126() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_142() {
        if (this.jj_3R_150()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_127()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_128()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_129()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_141() {
        if (this.jj_3R_149()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_140() {
        if (this.jj_3R_148()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_94()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_95()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_139() {
        if (this.jj_3R_147()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        Token xsp;
        block3: {
            if (this.jj_3R_70()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_70()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_138() {
        if (this.jj_3R_146()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_137() {
        if (this.jj_3R_145()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_136() {
        if (this.jj_3R_144()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_137()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_138()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_139()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_140()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_141()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_142()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_143()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_3R_116()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_3R_115()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        if (this.jj_3R_113()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_3R_112()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_3R_111()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_110()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_3R_109()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_3R_107()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_3R_106()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_3R_105()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_3R_102()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_3R_101()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_3R_99()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_3R_98()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_151() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_3R_97()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_3R_96()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_73()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_74()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_75()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_76()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_77()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_78()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_79()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_80()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_81()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_82()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_83()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_84()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_85()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_86()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_87()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_88()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_89()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_90()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_91()) {
                                                                                            return true;
                                                                                        }
                                                                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                            return false;
                                                                                        }
                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                        return false;
                                                                                    }
                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                    return false;
                                                                                }
                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                return false;
                                                                            }
                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                            return false;
                                                                        }
                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_149() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_154() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_153() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_158() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_157() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_152() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_157()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_158()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_123() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_122() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_153()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_154()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_116() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_148() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_3R_57()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_115() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_48()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_3R_59()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_51()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_52()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_42()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_36()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_37()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_38()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_39()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_40()) {
                                            return true;
                                        }
                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_145() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_121() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_31()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_120() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_119() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_120()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_121()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_156() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_155() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_3R_92()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_147() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_155()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_156()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_133() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_132() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_125() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_131() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_124() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_130() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_124()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_125()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_132()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_133()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_146() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public FMParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 66; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 66; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FMParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 66; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 66; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FMParser(FMParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 66; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(FMParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 66; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[115];
        for (i = 0; i < 115; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 66; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((this.jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 115; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, FMParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 13; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

