/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.InvalidReferenceException;
import freemarker.template.NonNumericalException;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.Date;

class EvaluationUtil {
    private EvaluationUtil() {
    }

    static String getString(TemplateScalarModel model, Expression expr, Environment env) throws TemplateException {
        String value = model.getAsString();
        if (value == null) {
            if (env.isClassicCompatible()) {
                return "";
            }
            throw new TemplateException(expr + " evaluated to null string.", env);
        }
        return value;
    }

    static Number getNumber(Expression expr, Environment env) throws TemplateException {
        TemplateModel model = expr.getAsTemplateModel(env);
        return EvaluationUtil.getNumber(model, expr, env);
    }

    static Number getNumber(TemplateModel model, Expression expr, Environment env) throws TemplateException {
        if (model instanceof TemplateNumberModel) {
            return EvaluationUtil.getNumber((TemplateNumberModel)model, expr, env);
        }
        if (model == null) {
            throw new InvalidReferenceException(expr + " is undefined.", env);
        }
        throw new NonNumericalException(expr + " is not a number, it is " + model.getClass().getName(), env);
    }

    static Number getNumber(TemplateNumberModel model, Expression expr, Environment env) throws TemplateModelException, TemplateException {
        Number value = model.getAsNumber();
        if (value == null) {
            throw new TemplateException(expr + " evaluated to null number.", env);
        }
        return value;
    }

    static Date getDate(TemplateDateModel model, Expression expr, Environment env) throws TemplateModelException, TemplateException {
        Date value = model.getAsDate();
        if (value == null) {
            throw new TemplateException(expr + " evaluated to null date.", env);
        }
        return value;
    }
}

