/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.OverloadedMethodModel;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class StaticModel
implements TemplateHashModelEx {
    private final Class clazz;
    private final BeansWrapper wrapper;
    private final Map map = new HashMap();

    StaticModel(Class clazz, BeansWrapper wrapper) throws IllegalAccessException, TemplateModelException {
        this.clazz = clazz;
        this.wrapper = wrapper;
        this.populate();
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object model = this.map.get(key);
        if (model instanceof TemplateModel) {
            return (TemplateModel)model;
        }
        if (model instanceof Field) {
            try {
                return this.wrapper.getOuterIdentity().wrap(((Field)model).get(null));
            }
            catch (IllegalAccessException e) {
                throw new TemplateModelException("Illegal access for field " + key + " of class " + this.clazz.getName());
            }
        }
        throw new TemplateModelException("No such key: " + key + " in class " + this.clazz.getName());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.keySet());
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.values());
    }

    private void populate() throws IllegalAccessException, TemplateModelException {
        if (!Modifier.isPublic(this.clazz.getModifiers())) {
            throw new IllegalAccessException("Can't wrap the non-public class " + this.clazz.getName());
        }
        if (this.wrapper.getExposureLevel() == 3) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            if (Modifier.isFinal(mod)) {
                try {
                    this.map.put(field.getName(), this.wrapper.getOuterIdentity().wrap(field.get(null)));
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            this.map.put(field.getName(), field);
        }
        if (this.wrapper.getExposureLevel() < 2) {
            Method[] methods = this.clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodMap methodMap;
                Method method = methods[i];
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !this.wrapper.isSafeMethod(method)) continue;
                String name = method.getName();
                Object obj = this.map.get(name);
                if (obj == null) {
                    this.map.put(name, method);
                    continue;
                }
                if (obj instanceof Method) {
                    methodMap = new MethodMap(name);
                    methodMap.addMethod((Method)obj);
                    methodMap.addMethod(method);
                    this.map.put(name, methodMap);
                    continue;
                }
                methodMap = (MethodMap)obj;
                methodMap.addMethod(method);
            }
            Iterator entries = this.map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object value = entry.getValue();
                if (value instanceof Method) {
                    entry.setValue(new SimpleMethodModel(null, (Method)value, this.wrapper));
                    continue;
                }
                if (!(value instanceof MethodMap)) continue;
                entry.setValue(new OverloadedMethodModel(null, (MethodMap)value, this.wrapper));
            }
        }
    }
}

