/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TCPClient;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.UDPClient;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class SimpleResolver
implements Resolver {
    public static final int DEFAULT_PORT = 53;
    public static final int DEFAULT_EDNS_PAYLOADSIZE = 1280;
    private InetSocketAddress address;
    private InetSocketAddress localAddress;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private OPTRecord queryOPT;
    private TSIG tsig;
    private long timeoutValue = 10000L;
    private static final short DEFAULT_UDPSIZE = 512;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;

    public SimpleResolver(String hostname) throws UnknownHostException {
        if (hostname == null && (hostname = ResolverConfig.getCurrentConfig().server()) == null) {
            hostname = defaultResolver;
        }
        InetAddress addr = hostname.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
        this.address = new InetSocketAddress(addr, 53);
    }

    public SimpleResolver() throws UnknownHostException {
        this(null);
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    public static void setDefaultResolver(String hostname) {
        defaultResolver = hostname;
    }

    public void setPort(int port) {
        this.address = new InetSocketAddress(this.address.getAddress(), port);
    }

    public void setAddress(InetSocketAddress addr) {
        this.address = addr;
    }

    public void setAddress(InetAddress addr) {
        this.address = new InetSocketAddress(addr, this.address.getPort());
    }

    public void setLocalAddress(InetSocketAddress addr) {
        this.localAddress = addr;
    }

    public void setLocalAddress(InetAddress addr) {
        this.localAddress = new InetSocketAddress(addr, 0);
    }

    public void setTCP(boolean flag) {
        this.useTCP = flag;
    }

    public void setIgnoreTruncation(boolean flag) {
        this.ignoreTruncation = flag;
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        if (level != 0 && level != -1) {
            throw new IllegalArgumentException("invalid EDNS level - must be 0 or -1");
        }
        if (payloadSize == 0) {
            payloadSize = 1280;
        }
        this.queryOPT = new OPTRecord(payloadSize, 0, level, flags, options);
    }

    public void setEDNS(int level) {
        this.setEDNS(level, 0, 0, null);
    }

    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    TSIG getTSIGKey() {
        return this.tsig;
    }

    public void setTimeout(int secs, int msecs) {
        this.timeoutValue = (long)secs * 1000L + (long)msecs;
    }

    public void setTimeout(int secs) {
        this.setTimeout(secs, 0);
    }

    long getTimeout() {
        return this.timeoutValue;
    }

    private Message parseMessage(byte[] b) throws WireParseException {
        try {
            return new Message(b);
        }
        catch (IOException e2) {
            WireParseException e2;
            if (Options.check("verbose")) {
                e2.printStackTrace();
            }
            if (!(e2 instanceof WireParseException)) {
                e2 = new WireParseException("Error parsing message");
            }
            throw (WireParseException)e2;
        }
    }

    private void verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return;
        }
        int error = tsig.verify(response, b, query.getTSIG());
        response.tsigState = error == 0 ? 1 : 4;
        if (Options.check("verbose")) {
            System.err.println("TSIG verify: " + Rcode.string(error));
        }
    }

    private void applyEDNS(Message query) {
        if (this.queryOPT == null || query.getOPT() != null) {
            return;
        }
        query.addRecord(this.queryOPT, 3);
    }

    private int maxUDPSize(Message query) {
        OPTRecord opt = query.getOPT();
        if (opt == null) {
            return 512;
        }
        return opt.getPayloadSize();
    }

    public Message send(Message query) throws IOException {
        Message response;
        Record question;
        if (Options.check("verbose")) {
            System.err.println("Sending to " + this.address.getAddress().getHostAddress() + ":" + this.address.getPort());
        }
        if (query.getHeader().getOpcode() == 0 && (question = query.getQuestion()) != null && question.getType() == 252) {
            return this.sendAXFR(query);
        }
        query = (Message)query.clone();
        this.applyEDNS(query);
        if (this.tsig != null) {
            this.tsig.apply(query, null);
        }
        byte[] out = query.toWire(65535);
        int udpSize = this.maxUDPSize(query);
        boolean tcp = false;
        long endTime = System.currentTimeMillis() + this.timeoutValue;
        while (true) {
            byte[] in;
            if (this.useTCP || out.length > udpSize) {
                tcp = true;
            }
            if ((in = tcp ? TCPClient.sendrecv(this.localAddress, this.address, out, endTime) : UDPClient.sendrecv(this.localAddress, this.address, out, udpSize, endTime)).length < 12) {
                throw new WireParseException("invalid DNS header - too short");
            }
            int id = ((in[0] & 0xFF) << 8) + (in[1] & 0xFF);
            int qid = query.getHeader().getID();
            if (id != qid) {
                String error = "invalid message id: expected " + qid + "; got id " + id;
                if (tcp) {
                    throw new WireParseException(error);
                }
                if (!Options.check("verbose")) continue;
                System.err.println(error);
                continue;
            }
            response = this.parseMessage(in);
            this.verifyTSIG(query, response, in, this.tsig);
            if (tcp || this.ignoreTruncation || !response.getHeader().getFlag(6)) break;
            tcp = true;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendAsync(Message query, ResolverListener listener) {
        Integer id;
        SimpleResolver simpleResolver = this;
        synchronized (simpleResolver) {
            id = new Integer(uniqueID++);
        }
        Record question = query.getQuestion();
        String qname = question != null ? question.getName().toString() : "(none)";
        String name = this.getClass() + ": " + qname;
        ResolveThread thread = new ResolveThread(this, query, id, listener);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
        return id;
    }

    private Message sendAXFR(Message query) throws IOException {
        Name qname = query.getQuestion().getName();
        ZoneTransferIn xfrin = ZoneTransferIn.newAXFR(qname, this.address, this.tsig);
        xfrin.setTimeout((int)(this.getTimeout() / 1000L));
        xfrin.setLocalAddress(this.localAddress);
        try {
            xfrin.run();
        }
        catch (ZoneTransferException e) {
            throw new WireParseException(e.getMessage());
        }
        List records = xfrin.getAXFR();
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(5);
        response.getHeader().setFlag(0);
        response.addRecord(query.getQuestion(), 0);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            response.addRecord((Record)it.next(), 1);
        }
        return response;
    }
}

