/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.module.filter.image;

import com.octo.captcha.module.filter.FilterConfigUtils;
import com.octo.captcha.module.jmx.JMXRegistrationHelper;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.ManageableCaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageCaptchaFilter
implements Filter {
    public static final String JMX_REGISTERING_NAME = "com.octo.captcha.module.servlet:object=ImageCaptchaFilter";
    public static final String CSV_DELIMITER = ";";
    public static final String CAPTCHA_ERROR_URL_PARAMETER = "CaptchaErrorURL";
    public static final String CAPTCHA_RENDERING_URL_PARAMETER = "CaptchaRenderingURL";
    public static final String CAPTCHA_VERIFICATION_URLS_PARAMETER = "CaptchaVerificationURLs";
    public static final String CAPTCHA_FAIL_URLS_PARAMETER = "CaptchaFailURLs";
    public static final String CAPTCHA_QUESTION_NAME_PARAMETER = "CaptchaQuestionParameterName";
    public static final String CAPTCHA_RESPONSE_PARAMETER_NAME_PARAMETER = "CaptchaChallengeResponseParameterName";
    private static final String CAPTCHA_SERVICE_CLASS_PARAMETER = "ImageCaptchaServiceClass";
    private static final String CAPTCHA_REGISTER_TO_MBEAN_SERVER_PARAMETER = "RegisterToMBeanServer";
    private boolean captchaRegisterToMBeanServer = false;
    private static String captchaQuestionParameterName = null;
    private ImageCaptchaService captchaService = null;
    private static String captchaRenderingURL = null;
    private static String captchaErrorURL = null;
    private static String captchaChallengeResponseParameterName = null;
    protected Hashtable verificationForwards = new Hashtable();
    protected String captchaServiceClassName;

    public static String getCaptchaRenderingURL() {
        return captchaRenderingURL;
    }

    public static String getCaptchaQuestionParameterName() {
        return captchaQuestionParameterName;
    }

    public static String getCaptchaChallengeResponseParameterName() {
        return captchaChallengeResponseParameterName;
    }

    /*
     * Unable to fully structure code
     */
    public void init(FilterConfig theFilterConfig) throws ServletException {
        ImageCaptchaFilter.captchaRenderingURL = FilterConfigUtils.getStringInitParameter(theFilterConfig, "CaptchaRenderingURL", true);
        ImageCaptchaFilter.captchaErrorURL = FilterConfigUtils.getStringInitParameter(theFilterConfig, "CaptchaErrorURL", true);
        captchaVerificationURLs = FilterConfigUtils.getStringInitParameter(theFilterConfig, "CaptchaVerificationURLs", true);
        captchaForwardErrorURLs = FilterConfigUtils.getStringInitParameter(theFilterConfig, "CaptchaFailURLs", true);
        verificationURLs = new StringTokenizer(captchaVerificationURLs, ";", false);
        forwardErrorURLs = new StringTokenizer(captchaForwardErrorURLs, ";", false);
        if (verificationURLs.countTokens() == forwardErrorURLs.countTokens()) ** GOTO lbl11
        throw new ServletException("CaptchaVerificationURLs and CaptchaFailURLs values are not consistant in web.xml : there should be exactly one forward error for each verification URL !");
lbl-1000:
        // 1 sources

        {
            this.verificationForwards.put(verificationURLs.nextToken(), forwardErrorURLs.nextToken());
lbl11:
            // 2 sources

            ** while (verificationURLs.hasMoreTokens())
        }
lbl12:
        // 1 sources

        ImageCaptchaFilter.captchaQuestionParameterName = FilterConfigUtils.getStringInitParameter(theFilterConfig, "CaptchaQuestionParameterName", true);
        ImageCaptchaFilter.captchaChallengeResponseParameterName = FilterConfigUtils.getStringInitParameter(theFilterConfig, "CaptchaChallengeResponseParameterName", true);
        this.captchaServiceClassName = FilterConfigUtils.getStringInitParameter(theFilterConfig, "ImageCaptchaServiceClass", true);
        this.captchaRegisterToMBeanServer = FilterConfigUtils.getBooleanInitParameter(theFilterConfig, "RegisterToMBeanServer", false);
        try {
            this.captchaService = (ImageCaptchaService)Class.forName(this.captchaServiceClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new CaptchaServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new CaptchaServiceException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CaptchaServiceException(e);
        }
        if (this.captchaRegisterToMBeanServer && this.captchaService instanceof ManageableCaptchaService) {
            manageable = (ManageableCaptchaService)this.captchaService;
            JMXRegistrationHelper.registerToMBeanServer(manageable, "com.octo.captcha.module.servlet:object=ImageCaptchaFilter");
        }
    }

    public void doFilter(ServletRequest theRequest, ServletResponse theResponse, FilterChain theFilterChain) throws IOException, ServletException {
        String servletPathInfo;
        HttpServletRequest request = (HttpServletRequest)theRequest;
        HttpServletResponse response = (HttpServletResponse)theResponse;
        StringBuffer servletPathBuff = new StringBuffer().append(request.getServletPath());
        if (request.getQueryString() != null) {
            servletPathBuff.append("?").append(request.getQueryString());
        }
        if ((servletPathInfo = servletPathBuff.toString()).startsWith(captchaRenderingURL)) {
            try {
                this.generateAndRenderCaptcha(request, response);
            }
            catch (Throwable e) {
                response.sendRedirect(captchaErrorURL);
                e.printStackTrace();
            }
        } else if (this.verificationForwards.containsKey(servletPathInfo)) {
            this.verifyAnswerToACaptchaChallenge(request, response, servletPathInfo, theFilterChain);
        } else {
            this.addQuestionToRequest(request, response);
            theFilterChain.doFilter(theRequest, theResponse);
        }
    }

    public void destroy() {
        if (this.captchaService instanceof ManageableCaptchaService && this.captchaRegisterToMBeanServer) {
            ManageableCaptchaService manageable = (ManageableCaptchaService)((Object)this.captchaService);
            JMXRegistrationHelper.unregisterFromMBeanServer(JMX_REGISTERING_NAME);
        }
    }

    private void addQuestionToRequest(HttpServletRequest theRequest, HttpServletResponse theResponse) {
        String captchaID = theRequest.getSession().getId();
        String question = this.captchaService.getQuestionForID(captchaID, theRequest.getLocale());
        theRequest.setAttribute(ImageCaptchaFilter.getCaptchaQuestionParameterName(), (Object)question);
    }

    private void generateAndRenderCaptcha(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException {
        String captchaID = theRequest.getSession().getId();
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage challenge = this.captchaService.getImageChallengeForID(captchaID, theRequest.getLocale());
            JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegOutputStream);
            jpegEncoder.encode(challenge);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (CaptchaServiceException e) {
            theResponse.sendError(404);
            return;
        }
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        theResponse.setHeader("Cache-Control", "no-store");
        theResponse.setHeader("Pragma", "no-cache");
        theResponse.setDateHeader("Expires", 0L);
        theResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = theResponse.getOutputStream();
        responseOutputStream.write(captchaChallengeAsJpeg);
    }

    private void verifyAnswerToACaptchaChallenge(HttpServletRequest theRequest, HttpServletResponse theResponse, String theVerificationURL, FilterChain theFilterChain) throws IOException, ServletException {
        String captchaID = theRequest.getSession().getId();
        String challengeResponse = theRequest.getParameter(captchaChallengeResponseParameterName);
        if (challengeResponse == null) {
            this.redirectError(theVerificationURL, theRequest, theResponse);
            return;
        }
        Boolean isResponseCorrect = Boolean.FALSE;
        try {
            isResponseCorrect = this.captchaService.validateResponseForID(captchaID, challengeResponse);
        }
        catch (CaptchaServiceException e) {
            // empty catch block
        }
        if (isResponseCorrect.booleanValue()) {
            this.forwardSuccess(theFilterChain, theRequest, theResponse);
        } else {
            this.redirectError(theVerificationURL, theRequest, theResponse);
        }
    }

    private void redirectError(String theVerificationURL, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException {
        this.removeParametersFromRequest(theRequest);
        try {
            String forwardErrorURL = theRequest.getContextPath() + (String)this.verificationForwards.get(theVerificationURL);
            theResponse.sendRedirect(forwardErrorURL);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void forwardSuccess(FilterChain theFilterChain, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException {
        this.removeParametersFromRequest(theRequest);
        try {
            theFilterChain.doFilter((ServletRequest)theRequest, (ServletResponse)theResponse);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void removeParametersFromRequest(HttpServletRequest theRequest) {
        theRequest.removeAttribute(ImageCaptchaFilter.getCaptchaChallengeResponseParameterName());
        theRequest.removeAttribute(ImageCaptchaFilter.getCaptchaQuestionParameterName());
    }
}

