/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.image;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.engine.image.ImageCaptchaEngine;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.ImageCaptchaFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public abstract class ListImageCaptchaEngine
extends ImageCaptchaEngine {
    List factories = new ArrayList();
    private Random myRandom = new Random();

    public ListImageCaptchaEngine() {
        this.buildInitialFactories();
        this.checkFactoriesSize();
    }

    protected abstract void buildInitialFactories();

    public boolean addFactory(ImageCaptchaFactory factory) {
        return this.factories.add(factory);
    }

    public void addFactories(ImageCaptchaFactory[] factories) {
        int i = 0;
        while (i < factories.length) {
            this.factories.add(factories[i]);
            ++i;
        }
    }

    public ImageCaptchaFactory getImageCaptchaFactory() {
        return (ImageCaptchaFactory)this.factories.get(this.myRandom.nextInt(this.factories.size()));
    }

    public ImageCaptcha getNextImageCaptcha() {
        return this.getImageCaptchaFactory().getImageCaptcha();
    }

    public ImageCaptcha getNextImageCaptcha(Locale locale) {
        return this.getImageCaptchaFactory().getImageCaptcha(locale);
    }

    private void checkFactoriesSize() {
        if (this.factories.size() == 0) {
            throw new CaptchaException("This gimpy has no factories. Please initialize it properly with the buildInitialFactory() called by the constructor or the addFactory() mehtod later!");
        }
    }
}

