/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import java.io.PrintStream;

public class Tracer {
    public void onRevertToParent() {
    }

    public void onSpawnWildcard() {
    }

    public void suspend() {
    }

    public void nextState(int n) {
    }

    public void onSpawnSuper(String superType) {
    }

    public void onText(String text) {
    }

    public void onConvertValue(String text, String field) {
    }

    public void onEnterAttribute(String uri, String local) {
    }

    public void onEnterElement(String uri, String local) {
    }

    public void onLeaveAttribute(String uri, String local) {
    }

    public void onLeaveElement(String uri, String local) {
    }

    public void onSpawnChild(String childType, String field) {
    }

    public static class Standard
    extends Tracer {
        private int indent = 0;
        private PrintStream out = System.out;

        public void onRevertToParent() {
            this.indent -= 3;
            this.out.print("revert to parent");
        }

        private void printIndent() {
            int i = 0;
            while (i < this.indent) {
                this.out.print(' ');
                ++i;
            }
        }

        public void suspend() {
            this.out.println();
        }

        public void nextState(int n) {
            this.out.println(" -> #" + n);
        }

        public void onSpawnSuper(String superType) {
            this.indent += 3;
            this.out.print("spawn a super class unmarshaller :" + superType);
        }

        public void onText(String text) {
            this.printIndent();
            this.out.print("text(" + text.trim() + ") ");
        }

        public void onConvertValue(String text, String field) {
            this.out.print("to " + field);
        }

        public void onEnterAttribute(String uri, String local) {
            this.printEvent("@", uri, local, "");
            ++this.indent;
        }

        public void onEnterElement(String uri, String local) {
            this.printEvent("<", uri, local, ">");
            ++this.indent;
        }

        public void onLeaveAttribute(String uri, String local) {
            --this.indent;
            this.printEvent("/@", uri, local, "");
        }

        public void onLeaveElement(String uri, String local) {
            --this.indent;
            this.printEvent("</", uri, local, ">");
        }

        public void onSpawnChild(String childType, String field) {
            this.indent += 3;
            this.out.print("spawn a child field:" + field + " type:" + childType);
        }

        private void printEvent(String prefix, String uri, String local, String suffix) {
            this.printIndent();
            this.out.print(prefix + '(' + uri + ',' + local + ')' + suffix + ' ');
        }
    }
}

