/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

public abstract class WhiteSpaceProcessor {
    protected static final boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    protected static final boolean isWhiteSpaceExceptSpace(char ch) {
        if (ch >= ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r';
    }

    public static String collapse(String text) {
        int len = text.length();
        int s = 0;
        while (s < len) {
            if (WhiteSpaceProcessor.isWhiteSpace(text.charAt(s))) break;
            ++s;
        }
        if (s == len) {
            return text;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            int i = 0;
            while (i < s) {
                result.append(text.charAt(i));
                ++i;
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        int i = s + 1;
        while (i < len) {
            char ch = text.charAt(i);
            boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
            if (!inStripMode || !b) {
                inStripMode = b;
                if (inStripMode) {
                    result.append(' ');
                } else {
                    result.append(ch);
                }
            }
            ++i;
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    public static String replace(String text) {
        int i = text.length() - 1;
        while (i >= 0 && !WhiteSpaceProcessor.isWhiteSpaceExceptSpace(text.charAt(i))) {
            --i;
        }
        if (i < 0) {
            return text;
        }
        char[] buf = text.toCharArray();
        buf[i--] = 32;
        while (i >= 0) {
            if (WhiteSpaceProcessor.isWhiteSpaceExceptSpace(buf[i])) {
                buf[i] = 32;
            }
            --i;
        }
        return new String(buf);
    }
}

