/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jzonic.jlo.Channel;
import org.jzonic.jlo.ErrorHandler;
import org.jzonic.jlo.LogConfiguration;
import org.jzonic.jlo.LogGenerator;
import org.jzonic.jlo.Logger;
import org.jzonic.jlo.Target;
import org.jzonic.jlo.VariableManager;
import org.jzonic.jlo.formatter.Formatter;
import org.jzonic.jlo.formatter.FormatterFactory;
import org.jzonic.jlo.handler.Handler;
import org.jzonic.jlo.handler.HandlerFactory;
import org.jzonic.jlo.reader.LogConfigurationReader;
import org.jzonic.jlo.reader.ReaderException;
import org.jzonic.jlo.reader.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLFileReader
implements LogConfigurationReader {
    private String fileName;
    private static final VariableManager variableManager = VariableManager.getInstance();

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public LogConfiguration parseConfiguration(String configurationName) throws ReaderException {
        ResourceLocator rl = new ResourceLocator();
        InputStream is = rl.findResource(this.fileName);
        if (is == null) {
            throw new ReaderException("the file " + this.fileName + " cannot be found in the classpath");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            ErrorHandler.reportError("Exception during parser configuration", pce);
            throw new ReaderException("Exception during parser configuration:" + pce.getMessage());
        }
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (SAXException se) {
            ErrorHandler.reportError("Exception while parsing the file", se);
            throw new ReaderException("Exception while parsing the file:" + se.getMessage());
        }
        catch (IOException ioe) {
            ErrorHandler.reportError("IO-Exception", ioe);
            throw new ReaderException("IO-Exception:" + ioe.getMessage());
        }
        return this.processXML(doc, configurationName);
    }

    private LogConfiguration processXML(Document doc, String configurationName) {
        LogConfiguration lc = new LogConfiguration(configurationName);
        this.getGenerators(doc, lc);
        this.getLoggers(doc, lc);
        this.getChannels(doc, lc);
        this.getChannels(doc, lc);
        this.getVariables(doc, lc);
        return lc;
    }

    private void getLoggers(Document doc, LogConfiguration lc) {
        NodeList nl = doc.getElementsByTagName("logger");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentLogger = curNode.getNodeValue();
            String lvl = "INFO";
            Vector<String> lgs = new Vector<String>();
            Node child = n.getFirstChild();
            while (child != null) {
                String generator = null;
                if (child.getNodeName().equals("level")) {
                    lvl = child.getFirstChild().getNodeValue();
                }
                if (child.getNodeName().equals("generator")) {
                    generator = child.getFirstChild().getNodeValue();
                    lgs.add(generator);
                }
                child = child.getNextSibling();
            }
            if (lgs.size() > 0) {
                int targets = Target.parse(lvl);
                Logger myLogger = new Logger(currentLogger, targets);
                int k = 0;
                while (k < lgs.size()) {
                    String lName = (String)lgs.get(k);
                    LogGenerator lg = lc.getLogGenerator(lName);
                    if (lg != null) {
                        myLogger.addLogGenerator(lg);
                        lc.addLogger(myLogger);
                    }
                    ++k;
                }
            } else {
                ErrorHandler.reportError("LogManager getLoggers: Using default LogGenerator for " + currentLogger);
                LogGenerator lg = lc.getLogGenerator("Default");
                int targets = Target.parse(lvl);
                Logger myLogger = new Logger(currentLogger, targets);
                myLogger.addLogGenerator(lg);
                lc.addLogger(myLogger);
            }
            ++i;
        }
    }

    private void getVariables(Document doc, LogConfiguration lc) {
        NodeList nl = doc.getElementsByTagName("variable");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String varName = curNode.getNodeValue();
            Node valueNode = curAtt.getNamedItem("value");
            String varValue = valueNode.getNodeValue();
            if (varName != null && varValue != null) {
                variableManager.addVariable(varName, varValue, lc.getName());
            }
            ++i;
        }
    }

    private void getChannels(Document doc, LogConfiguration lc) {
        NodeList nl = doc.getElementsByTagName("channel");
        int i = 0;
        while (i < nl.getLength()) {
            Channel myChannel;
            LogGenerator lg;
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentChannel = curNode.getNodeValue();
            String generator = null;
            String mode = "off";
            boolean running = false;
            Node child = n.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals("generator")) {
                    generator = child.getFirstChild().getNodeValue();
                }
                if (child.getNodeName().equals("mode")) {
                    mode = child.getFirstChild().getNodeValue();
                }
                child = child.getNextSibling();
            }
            if ((mode = mode.toLowerCase()).equals("on")) {
                running = true;
            }
            if (generator != null) {
                lg = lc.getLogGenerator(generator);
                if (lg != null) {
                    myChannel = new Channel(currentChannel, lg, running);
                    lc.addChannel(myChannel);
                }
            } else {
                ErrorHandler.reportError("LogManager getChannels: Using default LogGenerator for " + currentChannel);
                lg = lc.getLogGenerator("Default");
                myChannel = new Channel(currentChannel, lg, running);
                lc.addChannel(myChannel);
            }
            ++i;
        }
    }

    private void getGenerators(Document doc, LogConfiguration lc) {
        String currentGenerator = "default";
        NodeList nl = doc.getElementsByTagName("generator");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            if (curNode != null) {
                currentGenerator = curNode.getNodeValue();
            }
            Hashtable<String, String> params = new Hashtable<String, String>();
            String fmt = null;
            String hndl = null;
            Node child = n.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals("formatter")) {
                    fmt = child.getFirstChild().getNodeValue();
                }
                if (child.getNodeName().equals("handler")) {
                    hndl = child.getFirstChild().getNodeValue();
                }
                if (child.getNodeName().equals("parameter")) {
                    NamedNodeMap myAtt = child.getAttributes();
                    Node myNode = myAtt.getNamedItem("name");
                    String name = myNode.getNodeValue();
                    myNode = myAtt.getNamedItem("value");
                    String value = myNode.getNodeValue();
                    params.put(name, value);
                }
                child = child.getNextSibling();
            }
            if (hndl != null) {
                LogGenerator generator = this.createLogGenerator(currentGenerator, hndl, fmt, params, lc.getName());
                lc.addLogGenerator(generator);
            }
            ++i;
        }
    }

    public LogGenerator createLogGenerator(String name, String handlerName, String formatterName, Hashtable params, String configName) {
        Handler handler = HandlerFactory.getHandler(handlerName, configName);
        if (handler != null) {
            handler.setParameter(params);
        }
        Formatter formatter = null;
        if (formatterName != null) {
            formatter = FormatterFactory.getFormatter(formatterName, configName);
        }
        if (handler != null) {
            return new LogGenerator(name, handler, formatter);
        }
        return null;
    }
}

