/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResourceLocator
implements Serializable {
    private String myName;
    private File myFile;
    private URL myUrl;
    static /* synthetic */ Class class$org$jzonic$jlo$reader$ResourceLocator;

    public ResourceLocator() {
    }

    public ResourceLocator(String name) throws IOException {
        this.myName = name;
        SecurityException exception = null;
        try {
            if (this.tryClasspath(name)) {
                return;
            }
        }
        catch (SecurityException e) {
            exception = e;
        }
        try {
            if (this.tryLoader(name)) {
                return;
            }
        }
        catch (SecurityException e) {
            exception = e;
        }
        String msg = "";
        if (exception != null) {
            msg = ": " + exception;
        }
        throw new IOException("Resource <" + name + "> could not be found in " + "the CLASSPATH (" + System.getProperty("java.class.path") + "), nor could it be located by the classloader responsible for the " + "web application (WEB-INF/classes)" + msg);
    }

    public InputStream findResource(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }

    public String getName() {
        return this.myName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.myFile != null) {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }
        if (this.myUrl != null) {
            return new BufferedInputStream(this.myUrl.openStream());
        }
        return null;
    }

    public long lastModified() {
        if (this.myFile != null) {
            return this.myFile.lastModified();
        }
        if (this.myUrl != null) {
            try {
                return this.myUrl.openConnection().getLastModified();
            }
            catch (IOException e) {
                return Long.MAX_VALUE;
            }
        }
        return 0L;
    }

    public String getDirectory() {
        if (this.myFile != null) {
            return this.myFile.getParent();
        }
        if (this.myUrl != null) {
            return null;
        }
        return null;
    }

    private boolean tryClasspath(String filename) {
        if (filename == null) {
            return false;
        }
        String classpath = System.getProperty("java.class.path");
        String[] paths = ResourceLocator.split(classpath, File.pathSeparator);
        this.myFile = ResourceLocator.searchDirectories(paths, filename);
        return this.myFile != null;
    }

    private static File searchDirectories(String[] paths, String filename) {
        SecurityException exception = null;
        int i = 0;
        while (i < paths.length) {
            try {
                File file = new File(paths[i], filename);
                if (file.exists() && !file.isDirectory()) {
                    return file;
                }
            }
            catch (SecurityException e) {
                exception = e;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    private static String[] split(String str, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            v.addElement(tokenizer.nextToken());
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    private boolean tryLoader(String name) {
        URL res = (class$org$jzonic$jlo$reader$ResourceLocator == null ? (class$org$jzonic$jlo$reader$ResourceLocator = ResourceLocator.class$("org.jzonic.jlo.reader.ResourceLocator")) : class$org$jzonic$jlo$reader$ResourceLocator).getResource(name = "/" + name);
        if (res == null) {
            return false;
        }
        File resFile = ResourceLocator.urlToFile(res);
        if (resFile != null) {
            this.myFile = resFile;
        } else {
            this.myUrl = res;
        }
        return true;
    }

    private static File urlToFile(URL res) {
        String externalForm = res.toExternalForm();
        if (externalForm.startsWith("file:")) {
            return new File(externalForm.substring(5));
        }
        return null;
    }

    public String toString() {
        return "[Resource: File: " + this.myFile + " URL: " + this.myUrl + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

