/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class VariableManager {
    private static VariableManager vm = null;
    private HashMap varMapping = new HashMap();
    private Properties envVariables = this.getEnvVars();

    private VariableManager() {
    }

    public static VariableManager getInstance() {
        if (vm == null) {
            vm = new VariableManager();
        }
        return vm;
    }

    public void addVariable(String varName, String varValue, String configName) {
        HashMap<String, String> vars = (HashMap<String, String>)this.varMapping.get(configName);
        if (vars == null) {
            vars = new HashMap<String, String>();
        }
        vars.put(varName, varValue);
        this.varMapping.put(configName, vars);
    }

    public String replaceVariables(String text, String configName) {
        HashMap vars = (HashMap)this.varMapping.get(configName);
        if (vars != null && vars.size() > 0) {
            Iterator it = vars.keySet().iterator();
            int pos = 0;
            while (it.hasNext()) {
                String currentKey = (String)it.next();
                String value = (String)vars.get(currentKey);
                currentKey = "${" + currentKey + "}";
                pos = text.indexOf(currentKey);
                while (pos != -1) {
                    String firstPart = text.substring(0, pos);
                    String secondPart = text.substring(pos + currentKey.length());
                    text = firstPart + value + secondPart;
                    pos = text.indexOf(currentKey);
                }
            }
        }
        text = this.replaceSystemVar(text);
        return this.replaceEnvVar(text);
    }

    public int getVariableCount(String configName) {
        if (this.varMapping.containsKey(configName)) {
            return ((HashMap)this.varMapping.get(configName)).size();
        }
        return 0;
    }

    public String replaceSystemVar(String text) {
        if (text != null) {
            int idx = text.indexOf("${system:");
            while (idx != -1) {
                String firstPart = text.substring(0, idx);
                String envVar = text.substring(idx + 9, text.indexOf("}"));
                String secondPart = text.substring(idx + envVar.length() + 10);
                String value = System.getProperty(envVar);
                if (value == null) {
                    value = "${system:" + envVar + "}";
                }
                text = firstPart + value + secondPart;
                idx = text.indexOf("${system:", idx + 1);
            }
        }
        return text;
    }

    public String replaceEnvVar(String text) {
        if (text != null) {
            int idx = text.indexOf("${env:");
            while (idx != -1) {
                String firstPart = text.substring(0, idx);
                String envVar = text.substring(idx + 6, text.indexOf("}"));
                String secondPart = text.substring(idx + envVar.length() + 7);
                String value = this.envVariables.getProperty(envVar);
                if (value == null) {
                    value = "${env:" + envVar + "}";
                }
                text = firstPart + value + secondPart;
                idx = text.indexOf("${env:", idx + 1);
            }
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getEnvVars() {
        Process p = null;
        Properties envVars = new Properties();
        try {
            String line;
            Runtime r = Runtime.getRuntime();
            String OS = System.getProperty("os.name").toLowerCase();
            p = OS.indexOf("windows 9") > -1 ? r.exec("command.com /c set") : (OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1 ? r.exec("cmd.exe /c set") : r.exec("env"));
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                void var6_7;
                int idx = var6_7.indexOf(61);
                String key = var6_7.substring(0, idx);
                String value = var6_7.substring(idx + 1);
                envVars.setProperty(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return envVars;
    }
}

