/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.jzonic.jlo.Channel;
import org.jzonic.jlo.ErrorHandler;
import org.jzonic.jlo.FileWatcher;
import org.jzonic.jlo.LogConfiguration;
import org.jzonic.jlo.LogGenerator;
import org.jzonic.jlo.Logger;
import org.jzonic.jlo.Target;
import org.jzonic.jlo.events.FileListener;
import org.jzonic.jlo.events.FileListenerEvent;
import org.jzonic.jlo.formatter.DefaultFormatter;
import org.jzonic.jlo.handler.ConsoleHandler;
import org.jzonic.jlo.reader.LogConfigurationReader;
import org.jzonic.jlo.reader.ReaderException;
import org.jzonic.jlo.reader.XMLFileReader;

public class LogManager
extends LogFactory
implements FileListener {
    private LogConfiguration defaultConfiguration;
    private static LogManager lm = null;
    private HashMap configurations = new HashMap();
    private Logger defaultLogger;
    private Channel defaultChannel;
    private FileWatcher fileWatcher;

    public LogManager() {
        XMLFileReader reader = new XMLFileReader();
        reader.setFileName("jlo_logging.xml");
        this.readConfiguration(reader, "Default");
        this.fileWatcher = new FileWatcher();
        this.fileWatcher.addFileListener(this, "Default");
        this.defaultConfiguration = new LogConfiguration("default");
        this.defaultConfiguration.addLogger(this.getDefaultLogger());
        this.defaultLogger = this.getDefaultLogger();
        this.addDefaultChannel();
    }

    public static LogManager getInstance() {
        if (lm == null) {
            lm = new LogManager();
        }
        return lm;
    }

    public static Log getLog(String loggerName) {
        return LogManager.getLog(loggerName, "Default");
    }

    public static Log getLog(String loggerName, String configurationName) {
        if (lm == null) {
            lm = new LogManager();
        }
        if (configurationName == null) {
            Logger logger = LogManager.lm.defaultConfiguration.getLogger(loggerName);
            if (logger == null) {
                ErrorHandler.reportError("Logger " + loggerName + " in " + configurationName + " not found. Using default logger");
                return LogManager.lm.defaultLogger;
            }
            return logger;
        }
        Logger logger = lm.getLogConfiguration(configurationName).getLogger(loggerName);
        if (logger == null) {
            ErrorHandler.reportError("Logger " + loggerName + " in " + configurationName + " not found. Using default logger");
            return LogManager.lm.defaultLogger;
        }
        return logger;
    }

    public static Channel getChannel(String channelName) {
        return LogManager.getChannel(channelName, "Default");
    }

    public static Channel getChannel(String channelName, String configurationName) {
        if (lm == null) {
            lm = new LogManager();
        }
        if (configurationName == null) {
            Channel channel = LogManager.lm.defaultConfiguration.getChannel(channelName);
            if (channel == null) {
                return LogManager.lm.defaultChannel;
            }
            return channel;
        }
        Channel channel = lm.getLogConfiguration(configurationName).getChannel(channelName);
        if (channel == null) {
            return LogManager.lm.defaultChannel;
        }
        return channel;
    }

    public static boolean isChannelOn(String channelName) {
        return LogManager.isChannelOn(channelName, "Default");
    }

    public static boolean isChannelOn(String channelName, String configurationName) {
        Channel channel = LogManager.getChannel(channelName, configurationName);
        if (channel == null) {
            return false;
        }
        return channel.isOn();
    }

    private LogConfiguration getLogConfiguration() {
        return this.defaultConfiguration;
    }

    private LogConfiguration getLogConfiguration(String configurationName) {
        if (this.configurations.containsKey(configurationName)) {
            return (LogConfiguration)this.configurations.get(configurationName);
        }
        XMLFileReader reader = new XMLFileReader();
        reader.setFileName(configurationName + "_logging.xml");
        try {
            LogConfiguration lc = reader.parseConfiguration(configurationName);
            this.configurations.put(lc.getName(), lc);
            this.fileWatcher.addFileListener(this, configurationName);
            return lc;
        }
        catch (ReaderException re) {
            return this.defaultConfiguration;
        }
    }

    public boolean readConfiguration(LogConfigurationReader reader, String configurationName) {
        try {
            LogConfiguration lc = reader.parseConfiguration(configurationName);
            if (configurationName == null) {
                this.defaultConfiguration = lc;
            } else {
                this.configurations.put(configurationName, lc);
            }
            return true;
        }
        catch (ReaderException re) {
            return false;
        }
    }

    private Logger getDefaultLogger() {
        LogGenerator lg = this.getDefaultLogGenerator();
        Logger logger = new Logger("Default", Target.all.intValue());
        logger.addLogGenerator(lg);
        return logger;
    }

    private void addDefaultChannel() {
        Channel channel;
        LogGenerator lg = this.getDefaultLogGenerator();
        this.defaultChannel = channel = new Channel("Default", lg, false);
    }

    private LogGenerator getDefaultLogGenerator() {
        ConsoleHandler consoleHandler = new ConsoleHandler("Default");
        DefaultFormatter defaultFormatter = new DefaultFormatter("Default");
        LogGenerator lg = new LogGenerator("Default", consoleHandler, defaultFormatter);
        return lg;
    }

    public void fileChanged(FileListenerEvent e) {
        String configName = e.getConfigurationName();
        this.configurations.remove(configName);
        this.getLogConfiguration(configName);
    }

    public Object getAttribute(String str) {
        return null;
    }

    public String[] getAttributeNames() {
        return null;
    }

    public Log getInstance(String str) throws LogConfigurationException {
        return LogManager.getLog(str);
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return LogManager.getLog(clazz.getName());
    }

    public void release() {
    }

    public void removeAttribute(String str) {
    }

    public void setAttribute(String str, Object obj) {
    }
}

