/*
 * Decompiled with CFR 0.152.
 */
package org.jzonic.jlo;

import org.jzonic.jlo.LogGenerator;
import org.jzonic.jlo.LogRecord;
import org.jzonic.jlo.processor.LogProcessor;
import org.jzonic.jlo.processor.LogProcessorFactory;

public class Channel {
    private static final LogProcessor processor = LogProcessorFactory.getLogProcessor();
    private LogGenerator lg;
    private String name;
    private boolean on;

    public Channel(String name, LogGenerator lg) {
        this(name, lg, false);
    }

    public Channel(String name, LogGenerator lg, boolean on) {
        this.name = name;
        this.lg = lg;
        this.on = on;
    }

    public void log(String msg) {
        if (this.on) {
            this.log(msg, null);
        }
    }

    public void log(String msg, Throwable thrown) {
        if (this.on) {
            LogRecord lr = new LogRecord(msg);
            if (thrown != null) {
                lr.setThrown(thrown);
            }
            this.log(lr);
        }
    }

    public void log(LogRecord lr) {
        processor.processEvent(this.lg, lr);
    }

    public LogGenerator getLogGenerator() {
        return this.lg;
    }

    public String getChannelName() {
        return this.name;
    }

    public boolean isOn() {
        return this.on;
    }
}

