/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service;

import com.octo.captcha.Captcha;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.AbstractCaptchaService;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.EhcacheManageableCaptchaServiceMBean;
import com.octo.captcha.service.captchastore.CaptchaStore;
import com.octo.captcha.service.captchastore.MapCaptchaStore;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EhcacheManageableCaptchaService
extends AbstractCaptchaService
implements EhcacheManageableCaptchaServiceMBean {
    private static Log log = LogFactory.getLog((Class)(class$com$octo$captcha$service$EhcacheManageableCaptchaService == null ? (class$com$octo$captcha$service$EhcacheManageableCaptchaService = EhcacheManageableCaptchaService.class$("com.octo.captcha.service.EhcacheManageableCaptchaService")) : class$com$octo$captcha$service$EhcacheManageableCaptchaService));
    private CacheManager cacheManager;
    private int minGuarantedStorageDelayInSeconds;
    private int captchaStoreMaxSize;
    private int numberOfGeneratedCaptchas = 0;
    private int numberOfCorrectResponse = 0;
    private int numberOfUncorrectResponse = 0;
    public static final String CAPTCHA_STORE_CACHE_NAME = "CaptchaStoreCache";
    static /* synthetic */ Class class$com$octo$captcha$service$EhcacheManageableCaptchaService;

    protected EhcacheManageableCaptchaService(CaptchaEngine captchaEngine, int minGuarantedStorageDelayInSeconds, int maxCaptchaStoreSize) {
        super(new MapCaptchaStore(), captchaEngine);
        try {
            this.cacheManager = CacheManager.getInstance();
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        Cache cache = new Cache(CAPTCHA_STORE_CACHE_NAME, maxCaptchaStoreSize, true, false, (long)minGuarantedStorageDelayInSeconds, (long)minGuarantedStorageDelayInSeconds);
        try {
            if (this.cacheManager.cacheExists(CAPTCHA_STORE_CACHE_NAME)) {
                this.cacheManager.removeCache(CAPTCHA_STORE_CACHE_NAME);
            }
            this.cacheManager.addCache(cache);
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        this.store = new EhcacheStore(cache);
        this.captchaStoreMaxSize = maxCaptchaStoreSize;
        this.minGuarantedStorageDelayInSeconds = minGuarantedStorageDelayInSeconds;
    }

    public String getCaptchaEngineClass() {
        return this.engine.getClass().getName();
    }

    public void setCaptchaEngineClass(String theClassName) throws IllegalArgumentException {
        try {
            Object engine = Class.forName(theClassName).newInstance();
            if (!(engine instanceof CaptchaEngine)) {
                throw new IllegalArgumentException("Class is not instance of CaptchaEngine! " + theClassName);
            }
            this.engine = (CaptchaEngine)engine;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getMinGuarantedStorageDelayInSeconds() {
        return this.minGuarantedStorageDelayInSeconds;
    }

    public void setMinGuarantedStorageDelayInSeconds(int theMinGuarantedStorageDelayInSeconds) {
        this.minGuarantedStorageDelayInSeconds = theMinGuarantedStorageDelayInSeconds;
        this.updateCache();
    }

    public long getNumberOfGeneratedCaptchas() {
        return this.numberOfGeneratedCaptchas;
    }

    public long getNumberOfCorrectResponses() {
        return this.numberOfCorrectResponse;
    }

    public long getNumberOfUncorrectResponses() {
        return this.numberOfUncorrectResponse;
    }

    public int getCaptchaStoreSize() {
        return this.store.getSize();
    }

    public int getNumberOfGarbageCollectableCaptchas() {
        return 0;
    }

    public long getNumberOfGarbageCollectedCaptcha() {
        return 0L;
    }

    public int getCaptchaStoreSizeBeforeGarbageCollection() {
        return 0;
    }

    public void setCaptchaStoreSizeBeforeGarbageCollection(int captchaStoreSizeBeforeGarbageCollection) {
        throw new UnsupportedOperationException("the max store size is useless for eh cache implementation");
    }

    public void setCaptchaStoreMaxSize(int size) {
        this.captchaStoreMaxSize = size;
        this.updateCache();
    }

    public int getCaptchaStoreMaxSize() {
        return this.captchaStoreMaxSize;
    }

    public void garbageCollectCaptchaStore() {
        Iterator it = null;
        try {
            it = this.cacheManager.getCache(CAPTCHA_STORE_CACHE_NAME).getKeys().iterator();
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        while (it.hasNext()) {
            try {
                this.cacheManager.getCache(CAPTCHA_STORE_CACHE_NAME).get((Serializable)((Object)it.next().toString()));
            }
            catch (CacheException e) {
                log.error((Object)e);
            }
        }
    }

    public void emptyCaptchaStore() {
        this.store.empty();
    }

    private void updateCache() {
        Cache cache = new Cache(CAPTCHA_STORE_CACHE_NAME, this.captchaStoreMaxSize, true, false, (long)this.minGuarantedStorageDelayInSeconds, (long)this.minGuarantedStorageDelayInSeconds);
        Iterator it = null;
        try {
            it = this.copyCacheContent().iterator();
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        try {
            this.cacheManager.removeCache(CAPTCHA_STORE_CACHE_NAME);
            this.cacheManager.addCache(cache);
            this.store = new EhcacheStore(cache);
            Cache myCache = this.cacheManager.getCache(CAPTCHA_STORE_CACHE_NAME);
            long now = System.currentTimeMillis();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (now - el.getCreationTime() >= cache.getTimeToLiveSeconds() * 1000L) continue;
                myCache.put(el);
            }
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
    }

    private Collection copyCacheContent() throws CacheException {
        Cache currentcache = this.cacheManager.getCache(CAPTCHA_STORE_CACHE_NAME);
        Iterator it = currentcache.getKeys().iterator();
        HashSet<Element> els = new HashSet<Element>();
        while (it.hasNext()) {
            try {
                Element el = currentcache.get((Serializable)((Object)it.next().toString()));
                if (el == null) continue;
                els.add(el);
            }
            catch (CacheException e) {
                log.error((Object)e);
            }
        }
        return els;
    }

    protected Captcha generateAndStoreCaptcha(Locale locale, String ID) {
        Cache cache = this.getCache();
        try {
            if (cache.getSize() >= this.captchaStoreMaxSize) {
                throw new CaptchaServiceException("Store is full, try to increase CaptchaStore Size or to decrease time out");
            }
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
        Captcha captcha = this.engine.getNextCaptcha(locale);
        ++this.numberOfGeneratedCaptchas;
        Element el = new Element((Serializable)((Object)ID), (Serializable)captcha);
        cache.remove((Serializable)el);
        cache.put(el);
        return captcha;
    }

    private Cache getCache() {
        return this.cacheManager.getCache(CAPTCHA_STORE_CACHE_NAME);
    }

    public Boolean validateResponseForID(String ID, Object response) throws CaptchaServiceException {
        Boolean valid = super.validateResponseForID(ID, response);
        if (valid.booleanValue()) {
            ++this.numberOfCorrectResponse;
        } else {
            ++this.numberOfUncorrectResponse;
        }
        return valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EhcacheStore
    implements CaptchaStore {
        private Cache cache;

        public EhcacheStore(Cache cache) {
            this.cache = cache;
        }

        public boolean hasCaptcha(String id) {
            try {
                return this.cache.getKeys().contains(id);
            }
            catch (CacheException e) {
                log.error((Object)e);
                return false;
            }
        }

        public void storeCaptcha(String id, Captcha captcha) throws CaptchaServiceException {
            this.cache.put(new Element((Serializable)((Object)id), (Serializable)captcha));
        }

        public Captcha getCaptcha(String id) throws CaptchaServiceException {
            try {
                Element el = this.cache.get((Serializable)((Object)id));
                if (el != null) {
                    return (Captcha)el.getValue();
                }
                throw new CaptchaServiceException("no captcha for specified id is found");
            }
            catch (CacheException e) {
                throw new CaptchaServiceException(e);
            }
        }

        public boolean removeCaptcha(String id) {
            return this.cache.remove((Serializable)((Object)id));
        }

        public int getSize() {
            try {
                return this.cache.getSize();
            }
            catch (CacheException e) {
                log.error((Object)e);
                return -1;
            }
        }

        public Collection getKeys() {
            try {
                return this.cache.getKeys();
            }
            catch (CacheException e) {
                log.error((Object)e);
                return null;
            }
        }

        public void empty() {
            try {
                this.cache.removeAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

