/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.octo.captcha.Captcha;
import com.octo.captcha.engine.CaptchaEngine;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BufferedCaptchaEngineContainer
implements CaptchaEngine {
    public static final String BUFFER_CACHE_NAME = "BuffuredCaptchaEngineContainerCache";
    private static final Log log = LogFactory.getLog((Class)(class$com$octo$captcha$service$BufferedCaptchaEngineContainer == null ? (class$com$octo$captcha$service$BufferedCaptchaEngineContainer = BufferedCaptchaEngineContainer.class$("com.octo.captcha.service.BufferedCaptchaEngineContainer")) : class$com$octo$captcha$service$BufferedCaptchaEngineContainer));
    private CaptchaEngine captchaEngine;
    private Cache captchaBuffer;
    private ClockDaemon clockDaemon;
    private Integer bufferSize;
    private Integer maxMemorySize;
    private Boolean diskPersistant;
    private Long deamonPeriod;
    static /* synthetic */ Class class$com$octo$captcha$service$BufferedCaptchaEngineContainer;

    public final Captcha getNextCaptcha() {
        Captcha captcha = this.getNextCaptchaFromBuffer();
        if (captcha == null) {
            return this.captchaEngine.getNextCaptcha();
        }
        return captcha;
    }

    public final Captcha getNextCaptcha(Locale locale) {
        return this.captchaEngine.getNextCaptcha();
    }

    public BufferedCaptchaEngineContainer(CaptchaEngine engine, boolean diskPersistant, int bufferSize, int maxMemorySize, long deamonPeriod) {
        log.debug((Object)("Initializing BufferDeamon with a size of " + bufferSize + " a memory max size : " + maxMemorySize + " and a period of " + deamonPeriod));
        log.debug((Object)("Engine : " + engine.getClass()));
        this.bufferSize = new Integer(bufferSize);
        this.maxMemorySize = new Integer(maxMemorySize);
        this.diskPersistant = new Boolean(diskPersistant);
        this.deamonPeriod = new Long(deamonPeriod * 1000L);
        this.captchaEngine = engine;
        this.captchaBuffer = new Cache(BUFFER_CACHE_NAME, this.maxMemorySize.intValue(), maxMemorySize != bufferSize, true, 0L, 0L, diskPersistant, 0L);
        try {
            CacheManager.getInstance().addCache(this.captchaBuffer);
        }
        catch (CacheException e) {
            log.warn((Object)e);
        }
        log.debug((Object)"cache initialized");
        this.clockDaemon = new ClockDaemon();
        log.debug((Object)"demon initialized");
        this.startDaemon();
        log.debug((Object)"demon started");
    }

    public void startJob(long periods) {
        this.clockDaemon.executePeriodically(periods, (Runnable)new Job(this.captchaEngine, this.clockDaemon), false);
    }

    private Captcha getNextCaptchaFromBuffer() {
        Captcha captcha = null;
        try {
            int i = 0;
            while (i < this.bufferSize) {
                Integer I = new Integer(i);
                if (this.captchaBuffer.getKeys().contains(I)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("captcha found in buffer for key : " + i));
                    }
                    captcha = (Captcha)this.captchaBuffer.get((Serializable)I).getValue();
                    this.captchaBuffer.remove((Serializable)I);
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("captcha not found in buffer for key : " + i));
                }
                ++i;
            }
        }
        catch (Throwable e) {
            log.warn((Object)e);
        }
        return captcha;
    }

    public void stopDaemon() {
        this.clockDaemon.shutDown();
    }

    public void startDaemon() {
        this.startJob(this.deamonPeriod);
    }

    public void setDaemonPeriod(Long deamonPeriod) {
        this.deamonPeriod = new Long(deamonPeriod * 1000L);
        this.stopDaemon();
        this.startDaemon();
    }

    public Long getDaemonPeriod() {
        return this.deamonPeriod;
    }

    public Long getTotalBufferSize() {
        return new Long((long)this.captchaBuffer.getDiskStoreSize() + this.captchaBuffer.getMemoryStoreSize());
    }

    public Long getMemoryBufferSize() {
        return new Long(this.captchaBuffer.getMemoryStoreSize());
    }

    public Long getDiskBufferSize() {
        return new Long(this.captchaBuffer.getMemoryStoreSize());
    }

    public Long getBufferHitCount() {
        return new Long(this.captchaBuffer.getHitCount());
    }

    public Long getMaxMemorySize() {
        return new Long(this.captchaBuffer.getMaxElementsInMemory());
    }

    public String getCaptchaEngineClass() {
        return this.captchaEngine.getClass().getName();
    }

    public void setCaptchaEngineClass(String theClassName) throws IllegalArgumentException {
        try {
            Object engine = Class.forName(theClassName).newInstance();
            if (!(engine instanceof CaptchaEngine)) {
                throw new IllegalArgumentException("Class is not instance of CaptchaEngine! " + theClassName);
            }
            this.captchaEngine = (CaptchaEngine)engine;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Job
    implements Runnable {
        CaptchaEngine engine;
        ClockDaemon deamon;

        public Job(CaptchaEngine engine, ClockDaemon deamon) {
            this.engine = engine;
            this.deamon = deamon;
        }

        public void run() {
            this.deamon.getThread().setPriority(1);
            log.debug((Object)"Scheduled job has been triggered");
            Cache captchaCache = null;
            List keys = null;
            try {
                captchaCache = CacheManager.getInstance().getCache(BufferedCaptchaEngineContainer.BUFFER_CACHE_NAME);
                keys = captchaCache.getKeys();
                int i = 0;
                while (i < BufferedCaptchaEngineContainer.this.bufferSize) {
                    Integer I = new Integer(i);
                    if (!keys.contains(I)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("buffering new captcha for key : " + i));
                        }
                        captchaCache.put(new Element((Serializable)I, (Serializable)this.engine.getNextCaptcha()));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("captcha already exists in buffer for key : " + i));
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                log.warn((Object)e);
            }
        }
    }
}

