/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.wordtoimage;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.utils.ToolkitFactory;
import com.octo.captcha.component.image.wordtoimage.ComposedWordToImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.text.AttributedString;

public class FilteredComposedWordToImage
extends ComposedWordToImage {
    private ImageFilter[] backgroundFilters;
    private ImageFilter[] textFilters;
    private ImageFilter[] finalFilters;

    public FilteredComposedWordToImage(FontGenerator fontGenerator, BackgroundGenerator background, TextPaster textPaster, ImageFilter[] backgroundFilters, ImageFilter[] textFilters, ImageFilter[] finalFilters) {
        super(fontGenerator, background, textPaster);
        this.backgroundFilters = backgroundFilters;
        this.textFilters = textFilters;
        this.finalFilters = finalFilters;
    }

    public BufferedImage getImage(String word) throws CaptchaException {
        BufferedImage background = this.getBackround();
        AttributedString aword = this.getAttributedString(word, this.checkWordLenght(word));
        BufferedImage out = new BufferedImage(background.getWidth(), background.getHeight(), background.getType());
        Graphics2D g2 = (Graphics2D)out.getGraphics();
        g2.drawImage(background, 0, 0, out.getWidth(), out.getHeight(), null);
        this.applyFilters(out, this.backgroundFilters);
        BufferedImage transparent = new BufferedImage(out.getWidth(), out.getHeight(), out.getType());
        Graphics2D tpie = (Graphics2D)transparent.getGraphics();
        tpie.setBackground(Color.white);
        tpie.clearRect(0, 0, out.getWidth(), out.getHeight());
        tpie.setPaint(Color.white);
        tpie.dispose();
        transparent = this.pasteText(transparent, aword);
        this.applyFilters(transparent, this.textFilters);
        AlphaComposite c = AlphaComposite.getInstance(3, 0.7f);
        g2.setComposite(c);
        g2.drawImage((Image)transparent, 0, 0, null);
        g2.dispose();
        this.applyFilters(out, this.finalFilters);
        return out;
    }

    private void applyFilters(BufferedImage image, ImageFilter[] filters) {
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                ImageFilter backgroundFilter = filters[i];
                FilteredImageSource filtered = new FilteredImageSource(image.getSource(), backgroundFilter);
                Image temp = ToolkitFactory.getToolkit().createImage(filtered);
                image.getGraphics().drawImage(temp, 0, 0, Color.white, null);
                ++i;
            }
        }
    }
}

