/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.wordtoimage;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public abstract class AbstractWordToImage
implements WordToImage {
    public BufferedImage getImage(String word) throws CaptchaException {
        int wordLenght = this.checkWordLenght(word);
        AttributedString attributedWord = this.getAttributedString(word, wordLenght);
        BufferedImage background = this.getBackround();
        return this.pasteText(background, attributedWord);
    }

    AttributedString getAttributedString(String word, int wordLenght) {
        AttributedString attributedWord = new AttributedString(word);
        int i = 0;
        while (i < wordLenght) {
            Font font = this.getFont();
            attributedWord.addAttribute(TextAttribute.FONT, font, i, i + 1);
            ++i;
        }
        return attributedWord;
    }

    int checkWordLenght(String word) throws CaptchaException {
        if (word == null) {
            throw new CaptchaException("null word");
        }
        int wordLenght = word.length();
        if (wordLenght > this.getMaxAcceptedWordLenght() || wordLenght < this.getMinAcceptedWordLenght()) {
            throw new CaptchaException("invalid lenght word");
        }
        return wordLenght;
    }

    abstract Font getFont();

    abstract BufferedImage getBackround();

    abstract BufferedImage pasteText(BufferedImage var1, AttributedString var2) throws CaptchaException;

    public abstract int getMinFontSize();

    public abstract int getImageWidth();

    public abstract int getImageHeight();

    public abstract int getMinAcceptedWordLenght();

    public abstract int getMaxAcceptedWordLenght();
}

