/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.rmi.dgc.VMID;
import java.util.Date;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.masukomi.aspirin.core.Configuration;
import org.masukomi.aspirin.core.MailQue;
import org.masukomi.aspirin.core.SimpleMailWatcherImpl;
import org.masukomi.aspirin.core.SimpleMimeMessageGenerator;

public class MailQueTest
extends TestCase {
    MimeMessage testMessage;
    String messageId;
    public static final boolean debug = false;
    public static final int POP3PORT = 110;
    public static final int DISCONNECTED = 0;
    public static final int CONNECTED = 1;
    String user = "aspirin-test";
    String password = "test-aspirin";
    String host = "masukomi.org";
    private int state = 0;
    private Socket socket;
    private BufferedReader is;
    private PrintWriter out;
    static /* synthetic */ Class class$org$masukomi$aspirin$core$MailQueTest;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$masukomi$aspirin$core$MailQueTest == null ? (class$org$masukomi$aspirin$core$MailQueTest = MailQueTest.class$("org.masukomi.aspirin.core.MailQueTest")) : class$org$masukomi$aspirin$core$MailQueTest));
        System.exit(0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Configuration config = Configuration.getInstance();
        config.setMaxAttempts(1);
        config.setPostmaster("root@localhost");
        config.setDeliveryThreads(1);
        config.setRetryInterval(60000L);
        this.testMessage = SimpleMimeMessageGenerator.getNewMimeMessage();
        this.testMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress("aspirin-test@masukomi.org"));
        this.testMessage.setFrom((Address)new InternetAddress("jUnit-aspirin-test@masukomi.org"));
        this.messageId = new VMID().toString();
        this.testMessage.setSubject(this.messageId);
        StringBuffer body = new StringBuffer(System.getProperty("java.version"));
        body.append("\n");
        body.append("This is a test message from MailQueTest sent at ");
        body.append(new Date().toString());
        this.testMessage.setContent((Object)body.toString(), "text/plain");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public MailQueTest(String arg0) {
        super(arg0);
    }

    public void testQueMail() {
        try {
            SimpleMailWatcherImpl watcher = new SimpleMailWatcherImpl();
            MailQue.getInstance();
            MailQue.addListener(watcher);
            MailQue.queMail(this.testMessage);
            long startTime = System.currentTimeMillis();
            System.out.println("Waiting for send to complete. This may take a bit. ");
            MailQueTest.assertTrue((boolean)watcher.blockingSuccessCheck());
            System.out.println("Giving it 60 seconds to be processed by the server. ");
            try {
                Thread.currentThread();
                Thread.sleep(60000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                MailQueTest.assertTrue((boolean)false);
            }
            System.out.println("please note. If the following fails it may be due to delay in getting the");
            System.out.println("message across the net to the new server, or the server may be being slow. ");
            MailQueTest.assertTrue((boolean)this.checkForMessage(this.messageId));
            MailQueTest.assertTrue((MailQue.getInstance().getQue().size() == 0 ? 1 : 0) != 0);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            MailQueTest.assertTrue((boolean)false);
        }
    }

    public boolean checkForMessage(String messageId) {
        System.out.println("checking for message " + messageId + " on server");
        try {
            if (this.user == null || this.user.equals("")) {
                throw new RuntimeException("User Not Specified");
            }
            if (this.password == null || this.password.equals("")) {
                throw new RuntimeException("Password Not Specified");
            }
            if (this.host == null || this.host.equals("")) {
                throw new RuntimeException("Host Not Specified");
            }
            this.socket = new Socket(this.host, 110);
            this.state = 1;
            this.is = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.getResponse(this.is);
            this.out.println("USER " + this.user);
            this.getResponse(this.is);
            this.out.println("PASS " + this.password);
            this.getResponse(this.is);
            System.out.println("Login OK.");
            this.out.println("STAT");
            String droplist = this.getResponse(this.is);
            StringTokenizer st = new StringTokenizer(droplist);
            int nmesg = Integer.parseInt(st.nextToken());
            int mboxsize = Integer.parseInt(st.nextToken());
            boolean found = false;
            for (int i = 1; i <= nmesg; ++i) {
                this.out.println("RETR " + i);
                this.getResponse(this.is);
                String instr = this.is.readLine();
                while (!instr.equals(".")) {
                    if (instr.equals("Subject: " + messageId)) {
                        System.out.println("found " + messageId + " on server ");
                        found = true;
                    }
                    instr = this.is.readLine();
                }
                if (!found) continue;
                this.out.println("DELE " + i);
                this.getResponse(this.is);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return false;
    }

    public String getResponse(BufferedReader in) throws IOException {
        String str = in.readLine();
        StringTokenizer st = new StringTokenizer(str);
        String resp = st.nextToken();
        String mesg = st.nextToken("\r\n");
        if (!resp.equalsIgnoreCase("+OK")) {
            throw new RuntimeException("POP Error:" + mesg);
        }
        return mesg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

