/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.james.util.SimplifiedDateFormat;

public class SynchronizedDateFormat
implements SimplifiedDateFormat {
    private final DateFormat internalDateFormat;

    public SynchronizedDateFormat(String pattern, Locale locale) {
        this.internalDateFormat = new SimpleDateFormat(pattern, locale);
    }

    protected SynchronizedDateFormat(DateFormat theDateFormat) {
        this.internalDateFormat = theDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date d) {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            return this.internalDateFormat.format(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String source) throws ParseException {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            return this.internalDateFormat.parse(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeZone(TimeZone zone) {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            this.internalDateFormat.setTimeZone(zone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeZone getTimeZone() {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            return this.internalDateFormat.getTimeZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLenient(boolean lenient) {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            this.internalDateFormat.setLenient(lenient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLenient() {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            return this.internalDateFormat.isLenient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            return this.internalDateFormat.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormat dateFormat = this.internalDateFormat;
        synchronized (dateFormat) {
            return this.internalDateFormat.equals(obj);
        }
    }
}

