/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleSequence
extends WrappingTemplateModel
implements TemplateSequenceModel,
Serializable {
    protected final List list;

    public SimpleSequence() {
        this((ObjectWrapper)null);
    }

    SimpleSequence(int capacity) {
        this.list = new ArrayList(capacity);
    }

    public SimpleSequence(Collection collection) {
        this(collection, null);
    }

    public SimpleSequence(TemplateCollectionModel tcm) throws TemplateModelException {
        ArrayList<TemplateModel> alist = new ArrayList<TemplateModel>();
        TemplateModelIterator it = tcm.iterator();
        while (it.hasNext()) {
            alist.add(it.next());
        }
        alist.trimToSize();
        this.list = alist;
    }

    public SimpleSequence(ObjectWrapper wrapper) {
        super(wrapper);
        this.list = new ArrayList();
    }

    public SimpleSequence(Collection collection, ObjectWrapper wrapper) {
        super(wrapper);
        this.list = new ArrayList(collection);
    }

    public void add(Object obj) {
        this.list.add(obj);
    }

    public void add(boolean b) {
        if (b) {
            this.add(TemplateBooleanModel.TRUE);
        } else {
            this.add(TemplateBooleanModel.FALSE);
        }
    }

    public TemplateModel get(int i) throws TemplateModelException {
        try {
            Object value = this.list.get(i);
            if (value instanceof TemplateModel) {
                return (TemplateModel)value;
            }
            TemplateModel tm = this.wrap(value);
            this.list.set(i, tm);
            return tm;
        }
        catch (IndexOutOfBoundsException e) {
            throw new TemplateModelException(i + " out of bounds [0, " + this.list.size() + ")");
        }
    }

    public int size() {
        return this.list.size();
    }

    public SimpleSequence synchronizedWrapper() {
        return new SynchronizedSequence();
    }

    private class SynchronizedSequence
    extends SimpleSequence {
        private SynchronizedSequence() {
        }

        public synchronized void add(Object obj) {
            SimpleSequence.this.add(obj);
        }

        public synchronized TemplateModel get(int i) throws TemplateModelException {
            return SimpleSequence.this.get(i);
        }

        public synchronized int size() {
            return SimpleSequence.this.size();
        }
    }
}

