/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.ParseException;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;

final class PropertySetting
extends TemplateElement {
    private final String key;
    private final Expression value;

    PropertySetting(String key, Expression value) {
        this.key = key;
        this.value = value;
    }

    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        super.setLocation(template, beginColumn, beginLine, endColumn, endLine);
        if (!(this.key.equals("locale") || this.key.equals("number_format") || this.key.equals("time_format") || this.key.equals("date_format") || this.key.equals("datetime_format") || this.key.equals("time_zone") || this.key.equals("boolean_format") || this.key.equals("classic_compatible"))) {
            throw new ParseException("Error " + this.getStartLocation() + "\nInvalid setting name: " + this.key, beginLine, beginColumn);
        }
    }

    void accept(Environment env) throws TemplateException {
        TemplateModel mval = this.value.getAsTemplateModel(env);
        String strval = mval instanceof TemplateScalarModel ? ((TemplateScalarModel)mval).getAsString() : (mval instanceof TemplateBooleanModel ? (((TemplateBooleanModel)mval).getAsBoolean() ? "true" : "false") : (mval instanceof TemplateNumberModel ? ((TemplateNumberModel)mval).getAsNumber().toString() : this.value.getStringValue(env)));
        env.setSetting(this.key, strval);
    }

    public String getCanonicalForm() {
        return "<#setting " + this.key + "=" + this.value.getCanonicalForm() + "/>";
    }

    public String getDescription() {
        return "setting " + this.key + " set to " + "\"" + this.value + "\" " + "[" + this.getStartLocation() + "]";
    }
}

