/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.EvaluationUtil;
import freemarker.template.Expression;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

final class NumericalOutput
extends TemplateElement {
    private final Expression expression;
    private final boolean hasFormat;
    private final int minFracDigits;
    private final int maxFracDigits;
    private volatile FormatHolder formatCache;

    NumericalOutput(Expression expression) {
        this.expression = expression;
        this.hasFormat = false;
        this.minFracDigits = 0;
        this.maxFracDigits = 0;
    }

    NumericalOutput(Expression expression, int minFracDigits, int maxFracDigits) {
        this.expression = expression;
        this.hasFormat = true;
        this.minFracDigits = minFracDigits;
        this.maxFracDigits = maxFracDigits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(Environment env) throws TemplateException, IOException {
        Number num = EvaluationUtil.getNumber(this.expression, env);
        FormatHolder fmth = this.formatCache;
        if (fmth == null || !fmth.locale.equals(env.getLocale())) {
            NumericalOutput numericalOutput = this;
            synchronized (numericalOutput) {
                fmth = this.formatCache;
                if (fmth == null || !fmth.locale.equals(env.getLocale())) {
                    NumberFormat fmt = NumberFormat.getNumberInstance(env.getLocale());
                    if (this.hasFormat) {
                        fmt.setMinimumFractionDigits(this.minFracDigits);
                        fmt.setMaximumFractionDigits(this.maxFracDigits);
                    } else {
                        fmt.setMinimumFractionDigits(0);
                        fmt.setMaximumFractionDigits(50);
                    }
                    fmt.setGroupingUsed(false);
                    fmth = this.formatCache = new FormatHolder(fmt, env.getLocale());
                }
            }
        }
        env.getOut().write(fmth.format.format(num));
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("#{");
        buf.append(this.expression.getCanonicalForm());
        if (this.hasFormat) {
            buf.append(" ; ");
            buf.append("m");
            buf.append(this.minFracDigits);
            buf.append("M");
            buf.append(this.maxFracDigits);
        }
        buf.append("}");
        return buf.toString();
    }

    public String getDescription() {
        return this.getSource();
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }

    private class FormatHolder {
        final NumberFormat format;
        final Locale locale;

        FormatHolder(NumberFormat format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }
    }
}

