/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

class NamespaceBlock
extends TemplateElement {
    private String name;

    NamespaceBlock(String name, TemplateElement nestedBlock) {
        this.name = name;
        this.nestedBlock = nestedBlock;
    }

    void accept(Environment env) throws TemplateException, IOException {
        env.pushNamespace(this.name);
        env.visit(this.nestedBlock);
        env.popNamespace();
    }

    public String getDescription() {
        return "namespace " + this.name;
    }

    public String getCanonicalForm() {
        return "<#namespace " + this.name + ">" + this.nestedBlock.getCanonicalForm() + "</#namespace>";
    }
}

